/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.sitenode;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.DatabaseTransaction;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelDispatcherServlet;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.sitenode.ServletErrorReport;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.web.DispatcherServlet;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.WebContextExposer;
import com.arsdigita.web.WebExposer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SiteNodeDispatcher
extends KernelDispatcherServlet
implements Dispatcher {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/sitenode/SiteNodeDispatcher.java#42 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$sitenode$SiteNodeDispatcher == null ? (class$com$arsdigita$sitenode$SiteNodeDispatcher = SiteNodeDispatcher.class$("com.arsdigita.sitenode.SiteNodeDispatcher")) : class$com$arsdigita$sitenode$SiteNodeDispatcher).getName());
    private static SiteNodeDispatcher s_instance = null;
    static /* synthetic */ Class class$com$arsdigita$sitenode$SiteNodeDispatcher;

    public static synchronized SiteNodeDispatcher getInstance() {
        return s_instance;
    }

    public void dispatch(final HttpServletRequest req, final HttpServletResponse resp, RequestContext rc) throws IOException, ServletException {
        s_log.debug((Object)"SiteNodeDispatcher.dispatch called");
        WebExposer.initializeRequestLocals(req);
        DispatcherHelper.setRequest(req);
        Assert.assertNotNull(rc, "rc");
        SiteNode sn = this.getSiteNode(req, rc);
        if (sn == null) {
            resp.sendError(404, "getSiteNode returned null");
            throw new IllegalStateException("getSiteNode returned null");
        }
        final PackageInstance pkg = sn.getPackageInstance();
        if (pkg == null) {
            WebExposer.clearRequestLocals();
            resp.sendError(404, "SiteNode " + sn.getURL() + " has no package associated with it.");
            throw new IllegalStateException("SiteNode" + sn.getURL() + " has no package associated with it.");
        }
        boolean fallingBack = req.getAttribute(DispatcherServlet.FALLING_BACK_ATTRIBUTE) != null;
        String prefix = null;
        URL requestURL = null;
        if (fallingBack) {
            requestURL = (URL)req.getAttribute(BaseServlet.REQUEST_URL_ATTRIBUTE);
            prefix = requestURL.getContextPath() + requestURL.getServletPath();
        } else {
            String pathInfo = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            URL vhost = new URL(req);
            requestURL = new URL(req.getScheme(), vhost.getServerName(), vhost.getServerPort(), req.getContextPath(), "", pathInfo, new ParameterMap(req));
            prefix = "";
        }
        final SiteNodeRequestContext snrc = new SiteNodeRequestContext(req, rc, sn, prefix + sn.getURL());
        DispatcherHelper.setRequestContext(req, snrc);
        final Application app = Application.retrieveApplicationForSiteNode(sn);
        final UserContext uc = snrc.getUserContext();
        WebExposer.init(req, snrc.getServletContext(), uc);
        WebContextExposer wce = new WebContextExposer(Web.getContext());
        wce.init(app, requestURL);
        final ServletException[] servletException = new ServletException[]{null};
        final IOException[] ioException = new IOException[]{null};
        new KernelExcursion(){

            public void excurse() {
                this.setResource(app);
                this.setLocale(snrc.getLocale());
                this.setSessionID(req.getSession().getId());
                this.setTransaction(new DatabaseTransaction());
                DeveloperSupport.startStage("SiteNodeDispatcher.dispatch");
                try {
                    this.setParty(SiteNodeDispatcher.this.getCurrentUser(req, uc));
                    SiteNodeDispatcher.this.doDispatch(req, resp, snrc, pkg);
                    SessionManager.getSession().flushAll();
                }
                catch (RedirectSignal rs) {
                    SiteNodeDispatcher.this.redirect(rs, resp);
                }
                catch (IOException ioe) {
                    ioException[0] = ioe;
                }
                catch (ServletException se) {
                    Throwable root = se.getRootCause();
                    while (root instanceof ServletException) {
                        ServletException next = (ServletException)root;
                        root = next.getRootCause();
                    }
                    if (root instanceof RedirectSignal) {
                        SiteNodeDispatcher.this.redirect((RedirectSignal)root, resp);
                    } else {
                        ServletErrorReport report = new ServletErrorReport(se, req, resp);
                        report.logit();
                        servletException[0] = se;
                    }
                }
                catch (RuntimeException re) {
                    ServletErrorReport report = new ServletErrorReport(re, req, resp);
                    report.logit();
                    throw re;
                }
                finally {
                    WebExposer.clearRequestLocals();
                    DeveloperSupport.endStage("SiteNodeDispatcher.dispatch");
                }
            }
        }.run();
        if (servletException[0] != null) {
            throw servletException[0];
        }
        if (ioException[0] != null) {
            throw ioException[0];
        }
    }

    private void redirect(RedirectSignal rs, HttpServletResponse resp) {
        String url = resp.encodeRedirectURL(rs.getDestinationURL());
        TransactionContext context = SessionManager.getSession().getTransactionContext();
        if (context.inTxn()) {
            if (rs.isCommitRequested()) {
                context.commitTxn();
            } else {
                context.abortTxn();
            }
        }
        try {
            resp.sendRedirect(url);
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
    }

    private User getCurrentUser(HttpServletRequest sreq, UserContext uc) {
        User user = null;
        if (uc.isLoggedIn() && (user = uc.getUser()) == null) {
            s_log.warn((Object)"The user cookie cannot be found; clearing login state and redirecting to login again");
            try {
                uc.logout();
            }
            catch (LoginException le) {
                throw new UncheckedWrapperException(le);
            }
            UserContext.redirectToLoginPage(sreq);
        }
        return user;
    }

    private SiteNode getSiteNode(HttpServletRequest req, RequestContext rc) {
        String url = null;
        String pathInfo = req.getPathInfo();
        url = pathInfo == null ? rc.getRemainingURLPart() : pathInfo;
        if (url.length() == 0) {
            url = "/";
        }
        SiteNode sn = null;
        try {
            sn = SiteNode.getSiteNode(url, true);
        }
        catch (DataObjectNotFoundException nfe) {
            // empty catch block
        }
        return sn;
    }

    private void doDispatch(HttpServletRequest req, HttpServletResponse resp, SiteNodeRequestContext rci, PackageInstance pkg) throws IOException, ServletException {
        try {
            DeveloperSupport.endStage("SiteNodeDispatcher.dispatch getPackage");
            DeveloperSupport.startStage("SiteNodeDispatcher getDispatcher");
            Dispatcher dispatcher = pkg.getType().getDispatcher();
            DeveloperSupport.endStage("SiteNodeDispatcher getDispatcher");
            DeveloperSupport.startStage("SiteNodeDispatcher subdispatch");
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)Kernel.getContext().getDebugInfo());
            }
            dispatcher.dispatch(req, resp, rci);
            DeveloperSupport.endStage("SiteNodeDispatcher subdispatch");
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)"Error loading dispatcher", (Throwable)e);
            throw new ServletException("Error loading dispatcher", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException("Error loading dispatcher", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Error loading dispatcher", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException("Error loading dispatcher", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

