/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.kernel.Party;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;

public class PartyFilter
extends Filter {
    private BigDecimal m_partyID;
    private String m_partyType;

    public PartyFilter(Party party, String partyType) {
        this.m_partyID = party.getID();
        this.m_partyType = partyType;
    }

    public PartyFilter(BigDecimal partyID, String partyType) {
        this.m_partyID = partyID;
        this.m_partyType = partyType;
    }

    public final BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        TermDocs termDocs = reader.termDocs(new Term(this.m_partyType, this.m_partyID.toString()));
        while (termDocs.next()) {
            bits.set(termDocs.doc());
        }
        return bits;
    }
}

