/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.search.lucene.Adapter;
import com.arsdigita.search.lucene.Document;
import com.arsdigita.search.lucene.Registry;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DocumentObserver
implements com.arsdigita.search.DocumentObserver {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$DocumentObserver == null ? (class$com$arsdigita$search$lucene$DocumentObserver = DocumentObserver.class$("com.arsdigita.search.lucene.DocumentObserver")) : class$com$arsdigita$search$lucene$DocumentObserver));
    static /* synthetic */ Class class$com$arsdigita$search$lucene$DocumentObserver;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$arsdigita$search$lucene$Adapter;

    public void onSave(DomainObject dobj) {
        MetadataProvider adapter = MetadataProviderRegistry.findAdapter(dobj.getObjectType());
        BigDecimal id = (BigDecimal)dobj.getOID().get("id");
        Assert.exists(id, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DocumentObserver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        Document doc = Document.retrieve(id);
        if (doc == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Creating new document");
            }
            doc = Document.create(id);
            doc.setType(dobj.getObjectType().getQualifiedName());
        }
        if (adapter != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Processing object " + dobj.getOID() + " using new adapters"));
            }
            doc.setTypeSpecificInfo(adapter.getTypeSpecificInfo(dobj));
            doc.setLocale(adapter.getLocale(dobj));
            doc.setTitle(adapter.getTitle(dobj));
            doc.setSummary(adapter.getSummary(dobj));
            doc.setCreationDate(adapter.getCreationDate(dobj));
            Party party = adapter.getCreationParty(dobj);
            doc.setCreationParty(party == null ? null : party.getID());
            doc.setLastModifiedDate(adapter.getLastModifiedDate(dobj));
            party = adapter.getLastModifiedParty(dobj);
            doc.setLastModifiedParty(party == null ? null : party.getID());
            ContentProvider[] content = adapter.getContent(dobj, ContentType.TEXT);
            StringBuffer buf = new StringBuffer("");
            for (int i = 0; i < content.length; ++i) {
                Assert.truth(content[i].getType().equals(ContentType.TEXT), "content is text");
                buf.append(new String(content[i].getBytes()));
            }
            doc.setContent(buf.toString());
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Processing object " + dobj.getOID() + " using old adapters"));
            }
            Registry reg = Registry.getInstance();
            Adapter ladapter = reg.getAdapter(dobj.getObjectType());
            Assert.exists(ladapter, class$com$arsdigita$search$lucene$Adapter == null ? (class$com$arsdigita$search$lucene$Adapter = DocumentObserver.class$("com.arsdigita.search.lucene.Adapter")) : class$com$arsdigita$search$lucene$Adapter);
            doc.setTypeSpecificInfo(ladapter.getTypeSpecificInfo(dobj));
            doc.setLocale(ladapter.getLocale(dobj));
            doc.setTitle(ladapter.getTitle(dobj));
            doc.setSummary(ladapter.getSummary(dobj));
            doc.setCreationDate(ladapter.getCreationDate(dobj));
            Party party = ladapter.getCreationParty(dobj);
            doc.setCreationParty(party == null ? null : party.getID());
            doc.setLastModifiedDate(ladapter.getLastModifiedDate(dobj));
            party = ladapter.getLastModifiedParty(dobj);
            doc.setLastModifiedParty(party == null ? null : party.getID());
            doc.setContent(ladapter.getContent(dobj));
        }
        doc.setDirty(true);
        doc.save();
    }

    public void onDelete(DomainObject dobj) {
        BigDecimal id = (BigDecimal)dobj.getOID().get("id");
        Assert.exists(id, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DocumentObserver.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        Document doc = Document.retrieve(id);
        if (doc != null) {
            doc.setDeleted(true);
            doc.setDirty(true);
            doc.save();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

