/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.search.Search;
import com.arsdigita.search.SearchDataQuery;
import com.arsdigita.search.intermedia.SearchSpecification;
import com.arsdigita.util.StringUtils;

public class SimpleSearchSpecification
extends SearchSpecification {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/SimpleSearchSpecification.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static final String WORD_ESCAPE_BEGIN = "\"";
    static final String WORD_ESCAPE_END = "\"";
    static final String[] s_columns = new String[]{"object_id", "object_type", "summary", "link_text", "url_stub", "score"};
    private String m_object_type;
    private static final char[] cleaned_chars = new char[]{'|', '&', ',', '-', '*', ';', '{', '}', '%', '_', '$', '?', '!', '(', ')', '\'', ':', '@', '.', '<', '>', '#', '^', '+', '=', '[', ']', '~', '`'};
    private static final String[] cleaned_words = new String[]{"the", "of", "to", "with", "and", "or", "for", "this"};

    private static String quote(String text) {
        char q = '\'';
        StringBuffer result = new StringBuffer(text.length());
        result.append(q);
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == q) {
                result.append(q);
            }
            result.append(c[i]);
        }
        return result.append(q).toString();
    }

    public static String containsClause(String sc, String searchString, String xml_label, String raw_label) {
        String clause = "";
        String quotedSS = SimpleSearchSpecification.quote(searchString);
        if (xml_label != null) {
            clause = "(contains(" + sc + ".xml_content, " + quotedSS + ", " + xml_label + ") * " + Search.getConfig().getXMLContentWeight() + ") > 0";
        }
        if (raw_label != null) {
            if (!clause.equals("")) {
                clause = clause + " or ";
            }
            clause = clause + "(contains(" + sc + ".raw_content, " + quotedSS + ", " + raw_label + ") * " + Search.getConfig().getRawContentWeight() + ") > 0";
        }
        if (!clause.equals("")) {
            clause = "(" + clause + ")";
        }
        return clause;
    }

    private static String createSearchString(String object_type, String searchString) {
        StringBuffer sb = new StringBuffer("select c.object_id, c.object_type, ").append("c.link_text, c.url_stub, c.summary, (score(1)+score(2)) as score ").append("from search_content c ").append("where ").append(SimpleSearchSpecification.containsClause("c", searchString, "1", "2"));
        if (object_type != null) {
            sb.append(" and c.object_type = " + SimpleSearchSpecification.quote(object_type));
        }
        sb.append(" order by score desc");
        return sb.toString();
    }

    public SimpleSearchSpecification(String object_type, String searchString) {
        super(SimpleSearchSpecification.createSearchString(object_type, SimpleSearchSpecification.cleanSearchString(searchString, " and ")), s_columns);
        this.m_object_type = object_type;
    }

    public SimpleSearchSpecification(String searchString) {
        this(null, searchString);
    }

    private static boolean isCleanChar(char at) {
        for (int j = 0; j < cleaned_chars.length; ++j) {
            if (at != cleaned_chars[j]) continue;
            return false;
        }
        return true;
    }

    private static boolean isCleanWord(String word) {
        if (StringUtils.emptyString(word)) {
            return false;
        }
        for (int j = 0; j < cleaned_words.length; ++j) {
            if (!word.equalsIgnoreCase(cleaned_words[j])) continue;
            return false;
        }
        return true;
    }

    private static boolean maybeAppendWord(StringBuffer sb, StringBuffer word_sb, String joinString) {
        String word = new String(word_sb);
        if (SimpleSearchSpecification.isCleanWord(word)) {
            sb.append(joinString).append("\"").append(word).append("\"");
            return true;
        }
        return false;
    }

    public static String cleanSearchString(String searchString, String joinString) {
        StringBuffer sb = new StringBuffer();
        StringBuffer word_sb = new StringBuffer();
        boolean skip_whitespace = true;
        boolean in_quotes = false;
        String next_joinString = "";
        for (int i = 0; i < searchString.length(); ++i) {
            char at = searchString.charAt(i);
            if (skip_whitespace && (at == ' ' || at == '\t') || !SimpleSearchSpecification.isCleanChar(at)) continue;
            if (at == ' ' || at == '\t') {
                if (!in_quotes) {
                    if (SimpleSearchSpecification.maybeAppendWord(sb, word_sb, next_joinString)) {
                        next_joinString = joinString;
                    }
                    word_sb = new StringBuffer();
                    skip_whitespace = true;
                    continue;
                }
                skip_whitespace = true;
                word_sb.append(' ');
                continue;
            }
            if (at == '\"') {
                if (in_quotes) {
                    if (SimpleSearchSpecification.maybeAppendWord(sb, word_sb, next_joinString)) {
                        next_joinString = joinString;
                    }
                    word_sb = new StringBuffer();
                    skip_whitespace = true;
                    in_quotes = false;
                    continue;
                }
                if (word_sb.length() > 0 && SimpleSearchSpecification.maybeAppendWord(sb, word_sb, next_joinString)) {
                    next_joinString = joinString;
                }
                in_quotes = true;
                skip_whitespace = true;
                continue;
            }
            skip_whitespace = false;
            word_sb.append(at);
        }
        SimpleSearchSpecification.maybeAppendWord(sb, word_sb, next_joinString);
        return sb.toString();
    }

    public void setSelect(String sql, String[] columns) {
        throw new UnsupportedOperationException();
    }

    public DataQuery getPage(int page) {
        String sql_for_page = this.reformatSqlForPage(page);
        SearchDataQuery sdq = new SearchDataQuery(SessionManager.getSession(), sql_for_page, s_columns);
        return sdq;
    }

    public com.arsdigita.search.intermedia.SearchDataQuery getSearchPage(int page) {
        return (com.arsdigita.search.intermedia.SearchDataQuery)this.getPage(page);
    }
}

