/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.search.intermedia.ContentChangeTime;
import com.arsdigita.search.intermedia.IndexingTime;
import com.arsdigita.search.intermedia.TimerFinished;
import com.arsdigita.util.Assert;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

class BuildIndex {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/BuildIndex.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$search$intermedia$BuildIndex == null ? (class$com$arsdigita$search$intermedia$BuildIndex = BuildIndex.class$("com.arsdigita.search.intermedia.BuildIndex")) : class$com$arsdigita$search$intermedia$BuildIndex).getName());
    private static Timer s_Timer;
    private static long s_timerDelay;
    private static long s_syncDelay;
    private static long s_maxSyncDelay;
    private static long s_maxIndexingTime;
    private static long s_indexingRetryDelay;
    static /* synthetic */ Class class$com$arsdigita$search$intermedia$BuildIndex;

    BuildIndex() {
    }

    static void setParameterValues(int timerDelay, int syncDelay, int maxSyncDelay, int maxIndexingTime, int indexingRetryDelay) {
        s_log.debug((Object)"Setting search parameters");
        s_timerDelay = timerDelay;
        s_syncDelay = syncDelay;
        s_maxSyncDelay = maxSyncDelay;
        s_maxIndexingTime = maxIndexingTime;
        s_indexingRetryDelay = indexingRetryDelay;
        s_log.debug((Object)("timerDelay: " + timerDelay));
        s_log.debug((Object)("syncDelay: " + syncDelay));
        s_log.debug((Object)("maxSyncDelay: " + maxSyncDelay));
        s_log.debug((Object)("maxIndexingTime: " + maxIndexingTime));
        s_log.debug((Object)("indexingRetryDelay: " + indexingRetryDelay));
    }

    static synchronized void startTimer() {
        if (s_timerDelay == 0L) {
            s_log.debug((Object)"Turning of search since delay is 0");
            BuildIndex.stopTimer();
            return;
        }
        if (s_Timer != null) {
            s_log.debug((Object)"Timer exists");
            return;
        }
        s_Timer = new Timer();
        s_log.debug((Object)("Starting search timer with delay=" + s_timerDelay));
        s_Timer.schedule((TimerTask)new TimerFinished(), 1L, s_timerDelay);
    }

    static synchronized void stopTimer() {
        if (s_Timer == null) {
            s_log.debug((Object)"No timer to stop.");
            return;
        }
        s_Timer.cancel();
        s_Timer = null;
    }

    static synchronized void restartTimer(int timerDelay, int syncDelay, int maxSyncDelay, int maxIndexingTime, int indexingRetryDelay) {
        BuildIndex.setParameterValues(timerDelay, syncDelay, maxSyncDelay, maxIndexingTime, indexingRetryDelay);
        BuildIndex.stopTimer();
        BuildIndex.startTimer();
    }

    private static void startIndexing(String task) {
        try {
            s_log.info((Object)("Seach BuildIndex " + task + " task starting."));
            Session ssn = SessionManager.getSession();
            Connection con = ssn.getConnection();
            CallableStatement funCall = con.prepareCall("{ ? = call search_indexing.queue_task('" + task + "')}");
            funCall.registerOutParameter(1, 4);
            funCall.execute();
            int return_value = funCall.getInt(1);
            funCall.close();
            if (return_value == 0) {
                s_log.error((Object)("Search BuildIndex " + task + " could not start." + "  Previous job still active."));
            }
        }
        catch (SQLException e) {
            s_log.error((Object)"Search BuildIndex.startIndexing failed", (Throwable)e);
            return;
        }
    }

    public static synchronized void forceSyncNow() {
        IndexingTime it = IndexingTime.getIndexingTime();
        if (!it.getJobStatus().equals("running")) {
            s_log.debug((Object)"search timer: forcing sync now");
            BuildIndex.startIndexing("sync");
        } else {
            s_log.debug((Object)"search timer: not forcing sync now because sync is currently running");
        }
    }

    static synchronized void checkState() {
        IndexingTime it = IndexingTime.getIndexingTime();
        s_log.info((Object)("Search timer executed at " + new Date() + " State = " + it.getJobStatus()));
        if (it.getJobStatus().equals("finished")) {
            if (BuildIndex.shouldSyncAgain(it)) {
                BuildIndex.startIndexing("sync");
            } else {
                s_log.debug((Object)"Search timer: index resync needed, but must wait.");
            }
        } else if (it.getJobStatus().equals("failed")) {
            boolean pastRetryDelay;
            long timeSinceFailure = System.currentTimeMillis() - it.getTimeFailed();
            boolean bl = pastRetryDelay = timeSinceFailure >= s_indexingRetryDelay;
            if (pastRetryDelay) {
                BuildIndex.startIndexing("sync");
            }
        } else if (it.getJobStatus().equals("running")) {
            boolean indexingTimedOut;
            long timeSinceStart = System.currentTimeMillis() - it.getTimeStarted();
            boolean bl = indexingTimedOut = timeSinceStart > s_maxIndexingTime;
            if (indexingTimedOut) {
                s_log.error((Object)("Index sync timed out.  The index rebuild took longer than " + s_maxIndexingTime / 1000L + " seconds."));
            }
        }
    }

    private static boolean shouldSyncAgain(IndexingTime it) {
        Assert.truth(it.getJobStatus().equals("finished"));
        long timeLastChange = ContentChangeTime.getContentChangeTime();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Search timer: timeLastChange = " + new Date(timeLastChange) + " startTime = " + new Date(it.getTimeStarted())));
        }
        if (timeLastChange <= it.getTimeStarted()) {
            s_log.debug((Object)"Search timer: No need to resync index.");
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceLastChange = currentTime - timeLastChange;
        long earliestUnsynchedChange = ContentChangeTime.getEarliestTime(it.getTimeStarted());
        s_log.debug((Object)("Time since last change:" + timeSinceLastChange));
        long timeSinceFirstUnsynchedChange = currentTime - earliestUnsynchedChange;
        boolean shouldSync = timeSinceLastChange >= s_syncDelay || timeSinceFirstUnsynchedChange >= s_maxSyncDelay;
        return shouldSync;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

