/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.runtime;

import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.ConnectionSource;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DedicatedConnectionSource;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PooledConnectionSource;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DataInitEvent;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.Initializer;
import com.arsdigita.runtime.LegacyInitEvent;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import com.arsdigita.util.SystemProperties;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Startup
extends CompoundInitializer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/Startup.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$runtime$Startup == null ? (class$com$arsdigita$runtime$Startup = Startup.class$("com.arsdigita.runtime.Startup")) : class$com$arsdigita$runtime$Startup));
    private static final String s_model = "com/arsdigita/runtime/Initializer.pdl";
    private static final String INIT = "com.arsdigita.runtime.Initializer";
    private final ConnectionSource m_source;
    private static final Parameter s_init = new StringParameter("waf.runtime.init", 0, null);
    private static boolean s_hasRun = false;
    static /* synthetic */ Class class$com$arsdigita$runtime$Startup;
    static /* synthetic */ Class class$com$arsdigita$persistence$ConnectionSource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$MetadataRoot;
    static /* synthetic */ Class class$com$arsdigita$persistence$Session;
    static /* synthetic */ Class class$com$arsdigita$runtime$Initializer;

    public Startup() {
        this(new PooledConnectionSource(RuntimeConfig.getConfig().getJDBCURL(), RuntimeConfig.getConfig().getJDBCPoolSize(), RuntimeConfig.getConfig().getJDBCPingInterval()));
    }

    public Startup(ConnectionSource source) {
        super(s_log);
        Assert.exists(source, class$com$arsdigita$persistence$ConnectionSource == null ? (class$com$arsdigita$persistence$ConnectionSource = Startup.class$("com.arsdigita.persistence.ConnectionSource")) : class$com$arsdigita$persistence$ConnectionSource);
        this.m_source = source;
    }

    private void addWafInitializer() {
        String claas = (String)SystemProperties.get(s_init);
        if (claas != null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("adding: " + claas));
            }
            this.add((Initializer)Classes.newInstance(claas));
        }
    }

    protected void addRuntimeInitializers() {
        Collection names = this.getRuntimeInitializerNames();
        String[] inits = names.toArray(new String[0]);
        MetadataRoot mroot = Startup.root();
        Startup.sort(inits, this.session("initializer", mroot), mroot);
        for (int i = 0; i < inits.length; ++i) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("adding: " + inits[i]));
            }
            this.add((Initializer)Classes.newInstance(inits[i]));
        }
        this.addWafInitializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getRuntimeInitializerNames() {
        Session session = this.session("startup", Startup.root());
        LinkedList<String> initNames = new LinkedList<String>();
        DataCollection inits = session.retrieve(INIT);
        try {
            while (inits.next()) {
                String initName = (String)inits.get("className");
                initNames.add(initName);
            }
        }
        finally {
            inits.close();
        }
        return initNames;
    }

    private static MetadataRoot root() {
        MetadataRoot root = new MetadataRoot();
        PDLCompiler compiler = new PDLCompiler();
        InputStream in = (class$com$arsdigita$runtime$Startup == null ? (class$com$arsdigita$runtime$Startup = Startup.class$("com.arsdigita.runtime.Startup")) : class$com$arsdigita$runtime$Startup).getClassLoader().getResourceAsStream(s_model);
        compiler.parse(new InputStreamReader(in), s_model);
        compiler.emit(root);
        return root;
    }

    private Session session(String key, MetadataRoot root) {
        Assert.exists(key, class$java$lang$String == null ? (class$java$lang$String = Startup.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(root, class$com$arsdigita$persistence$metadata$MetadataRoot == null ? (class$com$arsdigita$persistence$metadata$MetadataRoot = Startup.class$("com.arsdigita.persistence.metadata.MetadataRoot")) : class$com$arsdigita$persistence$metadata$MetadataRoot);
        if (!SessionManager.hasSession(key)) {
            SessionManager.configure(key, root, this.m_source);
        }
        Session session = SessionManager.getSession(key);
        Assert.exists(session, class$com$arsdigita$persistence$Session == null ? (class$com$arsdigita$persistence$Session = Startup.class$("com.arsdigita.persistence.Session")) : class$com$arsdigita$persistence$Session);
        return session;
    }

    public static final void run(Session session, Initializer init) {
        Assert.exists(session, class$com$arsdigita$persistence$Session == null ? (class$com$arsdigita$persistence$Session = Startup.class$("com.arsdigita.persistence.Session")) : class$com$arsdigita$persistence$Session);
        Assert.exists(init, class$com$arsdigita$runtime$Initializer == null ? (class$com$arsdigita$runtime$Initializer = Startup.class$(INIT)) : class$com$arsdigita$runtime$Initializer);
        s_hasRun = true;
        PDLCompiler compiler = new PDLCompiler();
        MetadataRoot root = session.getMetadataRoot();
        Assert.exists(root, class$com$arsdigita$persistence$metadata$MetadataRoot == null ? (class$com$arsdigita$persistence$metadata$MetadataRoot = Startup.class$("com.arsdigita.persistence.metadata.MetadataRoot")) : class$com$arsdigita$persistence$metadata$MetadataRoot);
        init.init(new DataInitEvent(compiler));
        compiler.emit(root);
        init.init(new DomainInitEvent(new DomainObjectFactory()));
        init.init(new LegacyInitEvent(session));
    }

    public final void run() {
        s_log.info((Object)"Initializing WAF runtime");
        DbHelper.setDatabase(DbHelper.getDatabaseFromURL(RuntimeConfig.getConfig().getJDBCURL()));
        this.addRuntimeInitializers();
        MetadataRoot root = MetadataRoot.getMetadataRoot();
        Session session = this.session("default", root);
        Startup.run(session, this);
        s_log.info((Object)"Initialization complete");
    }

    public static boolean hasRun() {
        return s_hasRun;
    }

    public static final void main(String[] args) throws SQLException {
        String url = args.length == 0 ? RuntimeConfig.getConfig().getJDBCURL() : args[0];
        new Startup(new DedicatedConnectionSource(url)).run();
    }

    private static void sort(String[] inits, Session session, MetadataRoot mroot) {
        int before;
        HashSet<String> all = new HashSet<String>(Arrays.asList(inits));
        HashSet<String> provided = new HashSet<String>();
        ArrayList<String> sorted = new ArrayList<String>();
        ArrayList<String> in = new ArrayList<String>(Arrays.asList(inits));
        do {
            before = in.size();
            Iterator it = in.iterator();
            while (it.hasNext()) {
                HashSet<String> required = new HashSet<String>();
                String init = (String)it.next();
                DataObject dataobject = session.retrieve(new OID(mroot.getObjectType(INIT), (Object)init));
                DataAssociation da = (DataAssociation)dataobject.get("requirements");
                DataAssociationCursor cursor = da.cursor();
                while (cursor.next()) {
                    required.add((String)cursor.getDataObject().get("className"));
                }
                cursor.close();
                required.retainAll(all);
                if (!provided.containsAll(required)) continue;
                sorted.add(init);
                provided.add(init);
                it.remove();
            }
        } while (in.size() < before);
        if (in.size() > 0) {
            throw new IllegalStateException("circular dependencies: " + in);
        }
        int index = 0;
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            inits[index++] = (String)it.next();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

