/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.ConnectionSource;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.jdbc.Connections;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PooledConnectionSource
implements ConnectionSource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/PooledConnectionSource.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$persistence$PooledConnectionSource == null ? (class$com$arsdigita$persistence$PooledConnectionSource = PooledConnectionSource.class$("com.arsdigita.persistence.PooledConnectionSource")) : class$com$arsdigita$persistence$PooledConnectionSource));
    private String m_url;
    private int m_size;
    private long m_interval;
    private Set m_connections = new HashSet();
    private List m_available = new ArrayList();
    private List m_untested = new ArrayList();
    private static final String[] TYPES = new String[]{"TABLE"};
    static /* synthetic */ Class class$com$arsdigita$persistence$PooledConnectionSource;

    public PooledConnectionSource(String url, int size, long interval) {
        this.m_url = url;
        this.m_size = size;
        this.m_interval = interval;
        Tester tester = new Tester();
        tester.setDaemon(true);
        tester.start();
        if (this.m_interval > 0L) {
            Poller poller = new Poller();
            poller.setDaemon(true);
            poller.start();
        }
    }

    public synchronized Connection acquire() {
        while (this.m_available.isEmpty()) {
            if (this.m_connections.size() < this.m_size) {
                Connection result = Connections.acquire(this.m_url);
                this.m_connections.add(result);
                return result;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new UncheckedWrapperException(e);
            }
        }
        return (Connection)this.m_available.remove(0);
    }

    public synchronized void release(Connection conn) {
        boolean remove;
        if (!this.m_connections.contains(conn)) {
            throw new IllegalArgumentException("connection did come from ths source: " + conn);
        }
        try {
            remove = conn.isClosed();
        }
        catch (SQLException e) {
            s_log.warn((Object)"error calling Connection.isClosed()", (Throwable)e);
            remove = true;
        }
        if (remove) {
            this.remove(conn);
        } else {
            this.m_available.add(conn);
        }
        this.notify();
    }

    private synchronized void remove(Connection conn) {
        this.m_connections.remove(conn);
        this.m_available.remove(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void testAvailable() {
        List list = this.m_untested;
        synchronized (list) {
            this.m_untested.addAll(this.m_available);
            this.m_available.clear();
            this.m_untested.notify();
        }
    }

    private static SQLException test(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getTables(null, null, "dummy", TYPES);
            rs.close();
            return null;
        }
        catch (SQLException e) {
            return e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Tester
    extends Thread {
        private Tester() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList untested = new ArrayList();
            block7: while (true) {
                untested.clear();
                List list = PooledConnectionSource.this.m_untested;
                synchronized (list) {
                    if (PooledConnectionSource.this.m_untested.isEmpty()) {
                        try {
                            PooledConnectionSource.this.m_untested.wait();
                        }
                        catch (InterruptedException e) {
                            throw new UncheckedWrapperException(e);
                        }
                    }
                    untested.addAll(PooledConnectionSource.this.m_untested);
                    PooledConnectionSource.this.m_untested.clear();
                }
                Iterator it = untested.iterator();
                while (true) {
                    if (!it.hasNext()) continue block7;
                    Connection conn = (Connection)it.next();
                    SQLException e = PooledConnectionSource.test(conn);
                    if (e != null) {
                        s_log.warn((Object)"connection failed test", (Throwable)e);
                        try {
                            conn.close();
                        }
                        catch (SQLException ex) {
                            s_log.warn((Object)"error while closing bad connection", (Throwable)ex);
                        }
                    }
                    PooledConnectionSource.this.release(conn);
                }
                break;
            }
        }
    }

    private class Poller
    extends Thread {
        private Poller() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(PooledConnectionSource.this.m_interval);
                }
                catch (InterruptedException e) {
                    throw new UncheckedWrapperException(e);
                }
                PooledConnectionSource.this.testAvailable();
            }
        }
    }
}

