/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.packaging.Command;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.SchemaLoader;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.jdbc.Connections;
import com.arsdigita.xml.XML;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class Upgrade
extends Command {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Upgrade.java#14 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Options s_options = Upgrade.getOptions();
    private String m_from;
    private String m_to;
    private final List m_scripts = new ArrayList();
    static /* synthetic */ Class array$Ljava$lang$String;

    public Upgrade() {
        super("upgrade", "Upgrade a CCM package");
    }

    public boolean run(String[] args) {
        CommandLine line;
        if (args.length == 0) {
            this.usage(s_options, System.err, "PACKAGE-KEY");
            return false;
        }
        try {
            line = new PosixParser().parse(s_options, args);
        }
        catch (MissingOptionException moe) {
            System.err.println("Missing option " + moe.getMessage());
            this.usage(s_options, System.err, "PACKAGE-KEY");
            return false;
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        if (line.hasOption("usage") || line.hasOption("help")) {
            this.usage(s_options, System.out, "PACKAGE-KEY");
            return true;
        }
        String home = System.getProperty("ccm.home");
        if (home == null) {
            System.err.println("ccm.home system property is undefined");
            return false;
        }
        String[] keys = line.getArgs();
        if (keys.length == 0 || keys.length > 1) {
            this.usage(s_options, System.err, "PACKAGE-KEY");
            return false;
        }
        String key = keys[0];
        this.m_from = line.getOptionValue("from-version");
        this.m_to = line.getOptionValue("to-version");
        if (this.m_from == null || this.m_to == null) {
            this.usage(s_options, System.err, "PACKAGE-KEY");
            return false;
        }
        String spec = key + ".upgrade";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(spec);
        if (in == null) {
            System.err.println("Cannot find " + spec);
            return false;
        }
        XML.parse(in, new Parser());
        if (this.m_scripts.isEmpty()) {
            System.err.println("No appropriate upgrades found; make sure that your 'to' and 'from' versions match the intended upgrade exactly");
            return false;
        }
        Iterator iter = this.m_scripts.iterator();
        while (iter.hasNext()) {
            String[] parts = (String[])iter.next();
            String classname = parts[0];
            String sql = parts[1];
            if (classname != null) {
                Method method;
                Class clacc = Classes.loadClass(classname);
                System.out.println("Running Java upgrade " + clacc);
                try {
                    method = clacc.getMethod("main", array$Ljava$lang$String == null ? Upgrade.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
                }
                catch (NoSuchMethodException nsme) {
                    throw new UncheckedWrapperException(nsme);
                }
                catch (SecurityException se) {
                    throw new UncheckedWrapperException(se);
                }
                String[] params = line.getOptionValues("parameters");
                LinkedList<String> ll = new LinkedList<String>();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        String[] split = StringUtils.split(params[i], ',');
                        for (int j = 0; j < split.length; ++j) {
                            ll.add(split[j]);
                        }
                    }
                }
                try {
                    method.invoke(null, new Object[]{ll.toArray(new String[0])});
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new UncheckedWrapperException(iae);
                }
                catch (InvocationTargetException ite) {
                    throw new UncheckedWrapperException(ite);
                }
            }
            if (sql != null) {
                SchemaLoader loader = new SchemaLoader(sql);
                System.out.println("Running SQL upgrade " + loader + ", " + "loaded from the classpath");
                Connection conn = Connections.acquire(RuntimeConfig.getConfig().getJDBCURL());
                loader.run(conn);
                try {
                    conn.close();
                    continue;
                }
                catch (SQLException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"from-version");
        OptionBuilder.withDescription((String)"Upgrade from version VERSION");
        s_options.addOption(OptionBuilder.create());
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"to-version");
        OptionBuilder.withDescription((String)"Upgrade to version VERSION");
        s_options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"parameters");
        OptionBuilder.withDescription((String)"Parameters to pass to upgrade scripts");
        s_options.addOption(OptionBuilder.create());
    }

    private class Parser
    extends DefaultHandler {
        private String m_version;

        private Parser() {
        }

        public final void startElement(String uri, String lname, String qname, Attributes attrs) {
            if (lname.equals("version")) {
                String from = attrs.getValue(uri, "from");
                String to = attrs.getValue(uri, "to");
                Assert.exists(from);
                Assert.exists(to);
                this.m_version = from + "/" + to;
            }
            if (lname.equals("script")) {
                Assert.exists(this.m_version);
                Assert.exists(Upgrade.this.m_from);
                Assert.exists(Upgrade.this.m_to);
                if (this.m_version.equals(Upgrade.this.m_from + "/" + Upgrade.this.m_to)) {
                    String classname = attrs.getValue(uri, "class");
                    String sql = attrs.getValue(uri, "sql");
                    if (classname == null && sql == null || classname != null && sql != null) {
                        throw new IllegalArgumentException("The script element must have a 'class' argument or a 'sql' argument; it may not have both");
                    }
                    Upgrade.this.m_scripts.add(new String[]{classname, sql});
                }
            }
        }

        public final void endElement(String uri, String lname, String qname) {
            if (qname.equals("version")) {
                this.m_version = null;
            }
        }
    }
}

