/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.notification;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.notification.Notification;
import com.arsdigita.notification.QueueItem;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TimerTask;
import org.apache.log4j.Logger;

class RequestManager
extends TimerTask {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/notification/RequestManager.java#11 $ by $Author: dennis $,  $Date: 2004/04/07 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$notification$RequestManager == null ? (class$com$arsdigita$notification$RequestManager = RequestManager.class$("com.arsdigita.notification.RequestManager")) : class$com$arsdigita$notification$RequestManager).getName());
    private static final String REQUEST_ID = "requestID";
    private static final String PARTY_TO = "partyTo";
    private static final String NOTIFICATION_IN_QUEUE = "queued";
    private static final String UPDATE_NOTIFICATION_SUCCESSFUL = "com.arsdigita.notification.UpdateNotificationSuccessful";
    private static final String UPDATE_NOTIFICATION_FAILURE = "com.arsdigita.notification.UpdateNotificationFailure";
    private static final String UPDATE_NOTIFICATION_PARTIAL_FAILURE = "com.arsdigita.notification.UpdateNotificationPartialFailure";
    private static final String GET_PENDING_NOTIFCATIONS = "com.arsdigita.notification.GetPendingNotifications";
    private static final String DELETE_NOTIFICATION_QUEUED = "com.arsdigita.notification.DeleteNotificationQueued";
    private static final String GET_COMPLETE_NOTIFICATIONS = "com.arsdigita.notification.GetCompleteNotifications";
    static /* synthetic */ Class class$com$arsdigita$notification$RequestManager;

    RequestManager() {
    }

    public void run() {
        KernelExcursion rootExcursion = new KernelExcursion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                s_log.info((Object)"processing current requests.");
                long time = System.currentTimeMillis();
                boolean committedTxn = false;
                Session session = SessionManager.getSession();
                session.getTransactionContext().beginTxn();
                try {
                    session.retrieveDataOperation(RequestManager.UPDATE_NOTIFICATION_SUCCESSFUL).execute();
                    session.retrieveDataOperation(RequestManager.UPDATE_NOTIFICATION_FAILURE).execute();
                    session.retrieveDataOperation(RequestManager.UPDATE_NOTIFICATION_PARTIAL_FAILURE).execute();
                    session.retrieveDataOperation(RequestManager.DELETE_NOTIFICATION_QUEUED).execute();
                    DataQuery qry = session.retrieveQuery(RequestManager.GET_COMPLETE_NOTIFICATIONS);
                    while (qry.next()) {
                        try {
                            OID oid = new OID(Notification.BASE_DATA_OBJECT_TYPE, qry.get(RequestManager.REQUEST_ID));
                            Notification n = new Notification(oid);
                            n.delete();
                        }
                        catch (DataObjectNotFoundException e) {
                            s_log.error((Object)"Retrieve complete notification", (Throwable)e);
                        }
                    }
                    session.getTransactionContext().commitTxn();
                    committedTxn = true;
                }
                finally {
                    if (!committedTxn) {
                        session.getTransactionContext().abortTxn();
                    }
                }
                session.getTransactionContext().beginTxn();
                committedTxn = false;
                try {
                    DataQuery query = session.retrieveQuery(RequestManager.GET_PENDING_NOTIFCATIONS);
                    while (query.next()) {
                        BigDecimal requestID = (BigDecimal)query.get(RequestManager.REQUEST_ID);
                        BigDecimal partyTo = (BigDecimal)query.get(RequestManager.PARTY_TO);
                        try {
                            OID oid = new OID("com.arsdigita.kernel.Party", (Object)partyTo);
                            Party party = (Party)DomainObjectFactory.newInstance(oid);
                            Notification notification = new Notification(new OID(Notification.BASE_DATA_OBJECT_TYPE, (Object)requestID));
                            notification.setStatus(RequestManager.NOTIFICATION_IN_QUEUE);
                            notification.save();
                            Boolean isGroupExpand = notification.getExpandGroup();
                            boolean expand = true;
                            if (isGroupExpand != null) {
                                expand = isGroupExpand;
                            }
                            if (party instanceof User || !expand) {
                                QueueItem queued = new QueueItem(notification, party);
                                queued.save();
                                continue;
                            }
                            if (!(party instanceof Group)) continue;
                            Group group = (Group)party;
                            UserCollection userCollection = group.getAllMemberUsers();
                            while (userCollection.next()) {
                                User user = userCollection.getUser();
                                QueueItem queued = new QueueItem(notification, user);
                                queued.save();
                            }
                        }
                        catch (Exception e) {
                            s_log.warn((Object)"RequestManager", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                    session.getTransactionContext().commitTxn();
                    committedTxn = true;
                }
                finally {
                    if (!committedTxn) {
                        session.getTransactionContext().abortTxn();
                    }
                }
                time = System.currentTimeMillis() - time;
                s_log.info((Object)("RequestManager executed in " + time + " ms."));
            }
        };
        try {
            rootExcursion.run();
        }
        catch (Throwable t) {
            s_log.error((Object)"Unexpected error occured. RequestManager disabled", t);
            throw new UncheckedWrapperException(t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

