/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.messaging;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.Message;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.SortKey;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ThreadedMessage
extends Message {
    public static final String BASE_DATA_OBJECT_TYPE = (class$com$arsdigita$messaging$ThreadedMessage == null ? (class$com$arsdigita$messaging$ThreadedMessage = ThreadedMessage.class$("com.arsdigita.messaging.ThreadedMessage")) : class$com$arsdigita$messaging$ThreadedMessage).getName();
    private static final String ROOT_ID = "root";
    private static final String ROOT = "root";
    private static final String SORT_KEY = "sortKey";
    private boolean m_wasNew = false;
    private MessageThread m_thread = null;
    private ThreadedMessage m_root = null;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$messaging$ThreadedMessage == null ? (class$com$arsdigita$messaging$ThreadedMessage = ThreadedMessage.class$("com.arsdigita.messaging.ThreadedMessage")) : class$com$arsdigita$messaging$ThreadedMessage));
    static /* synthetic */ Class class$com$arsdigita$messaging$ThreadedMessage;

    public ThreadedMessage() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ThreadedMessage(Party f, String s) {
        this(f, s, null);
    }

    public ThreadedMessage(Party from, String subject, String body) {
        this();
        this.setFrom(from);
        this.setSubject(subject);
        this.setText(body);
    }

    public ThreadedMessage(String type) {
        super(type);
    }

    public ThreadedMessage(DataObject dataObject) {
        super(dataObject);
    }

    public ThreadedMessage(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ThreadedMessage(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ThreadedMessage newInstance() {
        return new ThreadedMessage();
    }

    public ThreadedMessage replyTo(Party from, String body) {
        ThreadedMessage reply = this.replyTo();
        reply.setFrom(from);
        reply.setText(body);
        return reply;
    }

    public ThreadedMessage replyTo() {
        return this.replyTo(this.newInstance());
    }

    public ThreadedMessage replyTo(ThreadedMessage reply) {
        SortKey nextKey = this.getNextChild();
        reply.getReplyInfo(this);
        if (this.getRoot() == null) {
            reply.setRootID(this.getID());
        } else {
            reply.setRootID(this.getRoot());
        }
        reply.setSortKey(nextKey);
        reply.setRefersTo(this.getRefersTo());
        this.getThread().updateForNewMessage(reply);
        this.getThread().save();
        return reply;
    }

    public BigDecimal getRoot() {
        return (BigDecimal)this.get("root");
    }

    public ThreadedMessage getRootMsg() {
        DataObject rootData;
        if (this.m_root == null && (rootData = (DataObject)this.get("root")) != null) {
            this.m_root = new ThreadedMessage(rootData);
        }
        return this.m_root;
    }

    public void setRoot(BigDecimal root) {
        throw new UnsupportedOperationException("ThreadedMessage.setRoot() is no longer supported. Use ThreadedMessage.replyTo() instead.");
    }

    private void setRootID(BigDecimal root) {
        this.set("root", root);
    }

    public SortKey getSortKey() {
        String key = (String)this.get(SORT_KEY);
        return key != null ? new SortKey(key) : null;
    }

    public void setSortKey(SortKey key) {
        this.set(SORT_KEY, key.toString());
    }

    public int getDepth() {
        SortKey key = this.getSortKey();
        return key == null ? 0 : key.getDepth();
    }

    public long getNumReplies() {
        return this.getThread().getNumReplies();
    }

    private void setThread(MessageThread mt) {
        this.m_thread = mt;
    }

    public MessageThread getThread() {
        if (this.m_thread == null) {
            BigDecimal rootID = this.getRoot();
            ThreadedMessage root = null;
            if (rootID == null) {
                root = this;
            } else {
                try {
                    root = new ThreadedMessage(rootID);
                }
                catch (DataObjectNotFoundException e) {
                    throw new UncheckedWrapperException("Tried to retrieve the root message (believed to have ID #" + rootID + ") of message #" + this.getID() + " and failed.  This is indicative of " + "something profoundly wrong with the state of " + "the database.", e);
                }
            }
            this.m_thread = MessageThread.getFromRootMessage(root);
        }
        return this.m_thread;
    }

    protected void beforeSave() {
        if (this.getRoot() == null && this.getSortKey() != null) {
            throw new PersistenceException("ThreadedMessage: root message must have a null sort key");
        }
        if (this.getRoot() != null && this.getSortKey() == null) {
            throw new PersistenceException("ThreadedMessage: non-root message must have a sort key");
        }
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        if (this.getRoot() == null && this.m_wasNew) {
            this.setThread(new MessageThread(this));
            this.getThread().save();
            this.m_wasNew = false;
        }
    }

    private SortKey getNextChild() {
        SortKey child;
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.messaging.maxSortKey");
        SortKey parent = this.getSortKey();
        if (this.getRoot() == null) {
            Filter f = query.addFilter("root = :root");
            f.set("root", this.getID());
            f = query.addEqualsFilter("sortSize", "3");
        } else {
            Filter f = query.addFilter("root = :root");
            f.set("root", this.getRoot());
            f = query.addFilter("sortKey like :parent");
            f.set("parent", parent + "%");
            f = query.addFilter("inReplyTo = :reply");
            f.set("reply", this.getID());
            f = query.addFilter("sortSize > :parentSize");
            f.set("parentSize", new Integer(parent.length()));
        }
        if (query.next()) {
            child = new SortKey((String)query.get(SORT_KEY));
            child.next();
            query.close();
        } else {
            child = parent == null ? new SortKey() : parent.getChild();
        }
        return child;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

