/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PrivilegeDescriptor {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PrivilegeDescriptor.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String ADMIN_NAME = "admin";
    private static final String EDIT_NAME = "edit";
    private static final String READ_NAME = "read";
    private static final String WRITE_NAME = "write";
    private static final String CREATE_NAME = "create";
    private static final String DELETE_NAME = "delete";
    private static final String CMS_STAFF_ADMIN = "cms_staff_admin";
    private static final String CMS_CATEGORY_ADMIN = "cms_category_admin";
    private static final String CMS_PUBLISH = "cms_publish";
    private static final String CMS_NEW_ITEM = "cms_new_item";
    private static final String CMS_EDIT_ITEM = "cms_edit_item";
    private static final String CMS_DELETE_ITEM = "cms_delete_item";
    private static final String CMS_READ_ITEM = "cms_read_item";
    private static final String CMS_PREVIEW_ITEM = "cms_preview_item";
    private static final String CMS_CATEGORIZE_ITEMS = "cms_categorize_items";
    public static final PrivilegeDescriptor ADMIN = new PrivilegeDescriptor("admin");
    public static final PrivilegeDescriptor EDIT = new PrivilegeDescriptor("edit");
    public static final PrivilegeDescriptor READ = new PrivilegeDescriptor("read");
    public static final PrivilegeDescriptor WRITE = new PrivilegeDescriptor("write");
    public static final PrivilegeDescriptor CREATE = new PrivilegeDescriptor("create");
    public static final PrivilegeDescriptor DELETE = new PrivilegeDescriptor("delete");
    private String m_displayName;
    private static Map s_privs = Collections.synchronizedMap(new HashMap());
    private String m_name;
    private String m_columnName;

    public static PrivilegeDescriptor createPrivilege(String name) throws PersistenceException {
        if (PrivilegeDescriptor.get(name) != null) {
            throw new IllegalArgumentException("Privilege " + name + " already exists");
        }
        DataObject priv = SessionManager.getSession().create("com.arsdigita.kernel.permissions.Privilege");
        priv.set("privilege", name);
        priv.save();
        PrivilegeDescriptor.addChildPrivilege(ADMIN_NAME, name);
        PrivilegeDescriptor desc = new PrivilegeDescriptor(name);
        PrivilegeDescriptor.put(desc);
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChildPrivilege(String privilegeName, String childPrivilegeName) {
        DataOperation addOp = SessionManager.getSession().retrieveDataOperation("com.arsdigita.kernel.permissions.addChildPrivilege");
        addOp.setParameter("privilege", privilegeName);
        addOp.setParameter("childPrivilege", childPrivilegeName);
        addOp.execute();
        Map map = s_privs;
        synchronized (map) {
            s_privs.remove(privilegeName);
            PrivilegeDescriptor priv = new PrivilegeDescriptor(privilegeName);
            s_privs.put(privilegeName, priv);
        }
    }

    public static PrivilegeDescriptor get(String privilegeName) {
        return (PrivilegeDescriptor)s_privs.get(privilegeName);
    }

    public static Collection getAll() {
        return s_privs.values();
    }

    public void deletePrivilege() throws PersistenceException {
        OID oid = new OID("com.arsdigita.kernel.permissions.Privilege", (Object)this.m_name);
        DataObject priv = SessionManager.getSession().retrieve(oid);
        priv.delete();
        s_privs.remove(this.m_name);
    }

    public final String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        if (this.m_displayName != null) {
            return this.m_displayName;
        }
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrivilegeDescriptor)) {
            return false;
        }
        if (this.m_name == null) {
            return false;
        }
        PrivilegeDescriptor p = (PrivilegeDescriptor)o;
        return this.m_name.equals(p.getName());
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public PrivilegeDescriptor(String name) {
        this.m_name = name;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.permissions.PrivilegeColumnNameMap");
        query.setParameter("privilege", name);
        if (!query.next()) {
            query.close();
            throw new RuntimeException("Couldn't find column name for privilege - " + name);
        }
        this.m_columnName = (String)query.get("columnName");
        query.close();
    }

    protected static void put(PrivilegeDescriptor privDesc) {
        s_privs.put(privDesc.getName(), privDesc);
    }

    public Collection getImplyingPrivilegeNames() {
        HashSet<String> impliedPrivileges = new HashSet<String>();
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.permissions.ImpliedPrivilege");
        query.setParameter("childPrivilege", this.m_name);
        while (query.next()) {
            impliedPrivileges.add((String)query.get("privilege"));
        }
        return impliedPrivileges;
    }

    public boolean isImpliedBy(PrivilegeDescriptor privilege) {
        return this.getImplyingPrivilegeNames().contains(privilege.getName());
    }

    private PrivilegeDescriptor getCanonical() {
        return PrivilegeDescriptor.get(this.getName());
    }

    public static void initialize() {
        DataCollection privs = SessionManager.getSession().retrieve("com.arsdigita.kernel.permissions.Privilege");
        while (privs.next()) {
            String name = (String)privs.get("privilege");
            PrivilegeDescriptor desc = new PrivilegeDescriptor(name);
            PrivilegeDescriptor.put(desc);
        }
        privs.close();
    }
}

