/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.Crypto;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class UserAuthentication
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/UserAuthentication.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$kernel$UserAuthentication == null ? (class$com$arsdigita$kernel$UserAuthentication = UserAuthentication.class$("com.arsdigita.kernel.UserAuthentication")) : class$com$arsdigita$kernel$UserAuthentication).getName());
    private User m_user;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.UserAuthentication";
    static /* synthetic */ Class class$com$arsdigita$kernel$UserAuthentication;

    public static UserAuthentication retrieveForUser(User user) throws DataObjectNotFoundException {
        return new UserAuthentication(UserAuthentication.getOIDfromUserOID(user.getOID()));
    }

    public static UserAuthentication retrieveForUser(OID userOID) throws DataObjectNotFoundException {
        return new UserAuthentication(UserAuthentication.getOIDfromUserOID(userOID));
    }

    public static UserAuthentication retrieveForUser(BigDecimal userID) throws DataObjectNotFoundException {
        return new UserAuthentication(new OID(BASE_DATA_OBJECT_TYPE, (Object)userID));
    }

    public static UserAuthentication retrieveForLoginName(String loginName) throws DataObjectNotFoundException {
        Filter f;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.UserAuthenticationForLogin");
        if (KernelHelper.emailIsPrimaryIdentifier()) {
            f = query.addFilter("primaryEmail=:primaryEmail");
            f.set("primaryEmail", loginName.toLowerCase());
        } else {
            f = query.addFilter("lowerScreenName=:lowerScreenName");
            f.set("lowerScreenName", loginName.toLowerCase());
        }
        if (!query.next()) {
            throw new DataObjectNotFoundException("Could not retrieve a UserAuthentication object for login name: " + loginName);
        }
        UserAuthentication user = new UserAuthentication(new OID(BASE_DATA_OBJECT_TYPE, query.get("id")));
        query.close();
        return user;
    }

    public static UserAuthentication createForUser(User user) {
        UserAuthentication auth = new UserAuthentication();
        auth.setUser(user);
        auth.set("party", user);
        return auth;
    }

    public static UserAuthentication createForUser(OID userOID) throws DataObjectNotFoundException {
        UserAuthentication auth = new UserAuthentication();
        auth.setUser(userOID);
        return auth;
    }

    public static UserAuthentication createForUser(BigDecimal userID) throws DataObjectNotFoundException {
        UserAuthentication auth = new UserAuthentication();
        auth.setUser(new OID("com.arsdigita.kernel.User", (Object)userID));
        return auth;
    }

    private UserAuthentication() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    private UserAuthentication(OID authOID) throws DataObjectNotFoundException {
        super(authOID);
    }

    UserAuthentication(DataObject dataObject) {
        super(dataObject);
    }

    public User getUser() {
        if (this.m_user == null) {
            this.m_user = User.retrieve((DataObject)this.get("user"));
        }
        return this.m_user;
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    void hashPassword() {
        if (this.get("salt") != null) {
            s_log.debug((Object)"hashPassword: password already hashed");
            return;
        }
        String password = (String)this.get("password");
        if (password == null) {
            s_log.debug((Object)"hashPassword: password is null");
            return;
        }
        this.setPassword(password.trim());
    }

    private String hashPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException("password must not be null");
        }
        if (!password.trim().equals(password)) {
            throw new IllegalArgumentException("password must not have leading or trailing spaces");
        }
        try {
            MessageDigest digester = Crypto.newDigester();
            digester.update(password.getBytes("UTF-8"));
            digester.update(this.getSalt());
            String digest = new String(new Base64().encode(digester.digest()));
            s_log.debug((Object)("hashPassword: digest == <" + digest + ">"));
            return digest;
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedWrapperException("Could not encode password", e);
        }
        catch (GeneralSecurityException e) {
            throw new UncheckedWrapperException("Could not calculate password hash", e);
        }
    }

    private byte[] getSalt() {
        String salt = (String)this.get("salt");
        s_log.debug((Object)("getSalt: salt == <" + salt + ">"));
        if (salt == null) {
            throw new IllegalStateException("salt must not be null");
        }
        return new Base64().decode(salt.getBytes());
    }

    private void setSalt(byte[] salt) {
        this.set("salt", new String(new Base64().encode(salt)));
    }

    private void setNewSalt() {
        try {
            byte[] salt = new byte[16];
            Crypto.getRandom().nextBytes(salt);
            this.setSalt(salt);
        }
        catch (GeneralSecurityException e) {
            throw new UncheckedWrapperException("Could not generate new salt", e);
        }
    }

    public void setPassword(String password) {
        this.setNewSalt();
        this.set("password", this.hashPassword(password));
    }

    public boolean isValidPassword(String password) {
        String stored = (String)this.get("password");
        s_log.debug((Object)("isValidPassword: stored == <" + stored + ">"));
        return this.hashPassword(password).equals(stored);
    }

    public String getPasswordQuestion() {
        return (String)this.get("passwordQuestion");
    }

    public void setPasswordQuestion(String question) {
        this.set("passwordQuestion", question);
    }

    public void setPasswordAnswer(String answer) {
        this.set("passwordAnswer", answer);
    }

    public boolean isValidAnswer(String answer) {
        if (answer == null) {
            return false;
        }
        return answer.equals(this.get("passwordAnswer"));
    }

    private static OID getOIDfromUserOID(OID userOID) {
        return new OID(BASE_DATA_OBJECT_TYPE, userOID.get("id"));
    }

    private void setUser(OID userOID) throws DataObjectNotFoundException {
        this.setUser(User.retrieve(userOID));
    }

    private void setUser(User user) {
        if (this.m_user != null) {
            throw new RuntimeException("This UserAuthentication instance already containes a User object.");
        }
        this.set("id", user.getID());
        this.setAssociation("user", user);
        this.set("primaryEmail", user.getPrimaryEmail().getEmailAddress());
        this.set("screenName", user.getScreenName());
        this.m_user = user;
    }

    private static String getLoginNameForUser(User user) {
        if (KernelHelper.emailIsPrimaryIdentifier()) {
            return user.getPrimaryEmail().getEmailAddress();
        }
        return user.getScreenName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

