/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizationException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.ResourceManager;
import com.arsdigita.xml.Document;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Stylesheet
extends ACSObject
implements Templates {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/Stylesheet.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_path;
    private ThreadLocal m_stylesheet = new ThreadLocal();
    private Templates m_trax_templates;
    private org.w3c.dom.Document m_stylesheetDOM;
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$kernel$Stylesheet == null ? (class$com$arsdigita$kernel$Stylesheet = Stylesheet.class$("com.arsdigita.kernel.Stylesheet")) : class$com$arsdigita$kernel$Stylesheet).getName());
    private static DocumentBuilderFactory s_dbFactory;
    private static final String XSL_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    private static final String SAXON = "SAXON";
    private static final String XSLTC = "XSLTC";
    private static ThreadLocal s_transformerFactory;
    private long m_lastModified = 0L;
    private static long s_ttl;
    private boolean m_valid = true;
    private List m_fileSources = new ArrayList();
    private List m_imports = new ArrayList();
    private static final String s_typeName = "com.arsdigita.kernel.Stylesheet";
    private static final String s_defaultOutputType = "text/html";
    static /* synthetic */ Class class$com$arsdigita$kernel$Stylesheet;

    private synchronized void setTemplates(Templates t) {
        this.m_trax_templates = t;
    }

    private synchronized Templates getTemplates() {
        return this.m_trax_templates;
    }

    protected String getBaseDataObjectType() {
        return s_typeName;
    }

    public Stylesheet() {
        super(s_typeName);
    }

    public Stylesheet(DataObject dataObject) {
        super(dataObject);
    }

    public Stylesheet(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Stylesheet(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(s_typeName, (Object)id));
    }

    public void initialize() {
        super.initialize();
        this.m_lastModified = System.currentTimeMillis();
        if (this.isNew()) {
            this.set("outputType", s_defaultOutputType);
        }
    }

    private Stylesheet loadStylesheet(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        this.m_lastModified = System.currentTimeMillis();
        Stylesheet.createFactories();
        DocumentBuilder db = null;
        db = s_dbFactory.newDocumentBuilder();
        this.m_stylesheetDOM = db.parse(is);
        return this;
    }

    public boolean isNewerThan(Stylesheet s) {
        if (s == null) {
            return true;
        }
        return this.m_lastModified >= s.m_lastModified;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    public void invalidate() {
        this.m_valid = false;
    }

    public boolean isValid() {
        return this.m_valid && (this.m_lastModified + s_ttl > System.currentTimeMillis() || this.sourcesUpToDate());
    }

    private boolean sourcesUpToDate() {
        boolean isOutOfDate;
        long lastMod;
        ResourceManager rm = ResourceManager.getInstance();
        Iterator i = this.m_fileSources.iterator();
        while (i.hasNext()) {
            String sourceName = ((FileSource)i.next()).getName();
            lastMod = rm.getLastModified(sourceName);
            isOutOfDate = lastMod > this.m_lastModified;
            if (!isOutOfDate) continue;
            return false;
        }
        i = this.m_imports.iterator();
        while (i.hasNext()) {
            File source = (File)i.next();
            lastMod = source.lastModified();
            isOutOfDate = lastMod > this.m_lastModified;
            if (!isOutOfDate) continue;
            return false;
        }
        this.m_lastModified = System.currentTimeMillis();
        return true;
    }

    public static void setTimeout(long ttl) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        s_ttl = ttl;
    }

    public static Stylesheet combineStylesheets(Stylesheet[] ssList) {
        Stylesheet ss = null;
        ArrayList<FileSource> fileSources = new ArrayList<FileSource>();
        ResourceManager rm = ResourceManager.getInstance();
        for (int i = 0; i < ssList.length; ++i) {
            Stylesheet tmpSS = ssList[i];
            String path = tmpSS.getPath();
            FileSource src = new FileSource(path);
            InputStream is = rm.getResourceAsStream(path);
            if (is == null) {
                s_cat.warn((Object)("Could not find stylesheet " + path));
            } else {
                try {
                    tmpSS.loadStylesheet(is);
                    src.makeValid();
                    ss = ss == null ? tmpSS : ss.composeStylesheet(tmpSS);
                    is.close();
                }
                catch (Exception ex) {
                    s_cat.error((Object)("error parsing stylesheet " + path), (Throwable)ex);
                }
            }
            fileSources.add(src);
        }
        if (ss != null) {
            ss.m_lastModified = System.currentTimeMillis();
            ss.m_fileSources = fileSources;
        }
        return ss;
    }

    public void setPath(String path) {
        this.m_path = path;
        this.set("pathName", path);
    }

    public String getPath() {
        if (this.m_path == null) {
            this.m_path = (String)this.get("pathName");
        }
        return this.m_path;
    }

    public String getDisplayName() {
        return this.getPath();
    }

    public List getSources() {
        return this.m_fileSources;
    }

    public void setOutputType(String type) {
        this.set("outputType", type);
    }

    public String getOutputType(String type) {
        return (String)this.get("outputType");
    }

    public com.arsdigita.globalization.Locale getLocale() {
        return (com.arsdigita.globalization.Locale)this.get("locale");
    }

    public void setLocale(com.arsdigita.globalization.Locale locale) {
        this.setAssociation("locale", locale);
    }

    public void setLocale(Locale locale) {
        try {
            this.setLocale(com.arsdigita.globalization.Locale.fromJavaLocale(locale));
        }
        catch (GlobalizationException ge) {
            s_cat.error((Object)("Locale " + locale.toString() + " is not supported."), (Throwable)ge);
        }
    }

    public Stylesheet composeStylesheet(Stylesheet s) {
        Stylesheet newSS = new Stylesheet();
        Stylesheet[] tmp = new Stylesheet[]{this, s};
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null) continue;
            Iterator it = tmp[i].m_fileSources.iterator();
            while (it.hasNext()) {
                newSS.m_fileSources.add(it.next());
            }
            if (tmp[i].m_stylesheetDOM != null) continue;
            String path = tmp[i].getPath();
            ResourceManager rm = ResourceManager.getInstance();
            try {
                tmp[i].loadStylesheet(rm.getResourceAsStream(path));
                continue;
            }
            catch (Exception pce) {
                s_cat.error((Object)"error in compose", (Throwable)pce);
            }
        }
        newSS.setTemplates(null);
        newSS.m_stylesheet.set(null);
        newSS.m_stylesheetDOM = s != null && s.m_stylesheetDOM != null && this.m_stylesheetDOM != null ? Stylesheet.composeStylesheet(new org.w3c.dom.Document[]{s.m_stylesheetDOM, this.m_stylesheetDOM}) : (s != null && s.m_stylesheetDOM != null ? s.m_stylesheetDOM : this.m_stylesheetDOM);
        newSS.m_lastModified = System.currentTimeMillis();
        return newSS;
    }

    private static boolean usingSaxon() {
        String trans = System.getProperty("javax.xml.transform.TransformerFactory");
        if (trans == null) {
            return false;
        }
        return trans.indexOf("saxon") != -1;
    }

    private static boolean usingXSLTC() {
        String trans = System.getProperty("javax.xml.transform.TransformerFactory");
        if (trans == null) {
            return false;
        }
        return trans.indexOf("xsltc") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Transformer newTransformer() throws TransformerConfigurationException {
        Object transformer;
        ResourceManager rm;
        Source ssSource = null;
        if (this.getTemplates() == null && this.m_stylesheetDOM != null) {
            ssSource = new DOMSource(this.m_stylesheetDOM);
            if (Stylesheet.usingSaxon()) {
                rm = ResourceManager.getInstance();
                String pathn = rm.getResourceAsFile(this.getPath()).getAbsolutePath();
                ssSource.setSystemId(pathn);
            } else {
                ssSource.setSystemId("DOMSource");
            }
        } else if (!(this.m_stylesheetDOM != null || this.isValid() && this.getTemplates() != null)) {
            if (this.m_fileSources.size() == 0) {
                FileSource src = new FileSource(this.getPath());
                src.makeValid();
                this.m_fileSources.add(src);
            }
            rm = ResourceManager.getInstance();
            ssSource = new StreamSource(rm.getResourceAsFile(this.getPath()));
            if (Stylesheet.usingSaxon()) {
                String pathname = rm.getResourceAsFile(this.getPath()).getAbsolutePath();
                ssSource.setSystemId(pathname);
            }
            this.m_lastModified = System.currentTimeMillis();
            this.m_imports = this.getImports();
        }
        if (ssSource != null) {
            TransformerFactory tfact = null;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                tfact = (TransformerFactory)s_transformerFactory.get();
                if (tfact == null) {
                    tfact = TransformerFactory.newInstance();
                    if (Stylesheet.usingXSLTC()) {
                        tfact.setAttribute("disable-inlining", new Boolean(true));
                        s_cat.info((Object)"set disable-inlining to true for XSLSTC");
                        tfact.setErrorListener(new ErrorListener(){

                            public void warning(TransformerException transformerException) throws TransformerException {
                                s_cat.warn((Object)("Transformer warning: " + transformerException.getMessage()), (Throwable)transformerException);
                            }

                            public void error(TransformerException transformerException) throws TransformerException {
                                s_cat.error((Object)("Transformer error: " + transformerException.getMessage()), (Throwable)transformerException);
                            }

                            public void fatalError(TransformerException transformerException) throws TransformerException {
                                s_cat.fatal((Object)("Transformer FATAL: " + transformerException.getMessage()), (Throwable)transformerException);
                            }
                        });
                    }
                    s_transformerFactory.set(tfact);
                }
            }
            this.setTemplates(tfact.newTemplates(ssSource));
            this.m_stylesheet.set(null);
        }
        if ((transformer = this.m_stylesheet.get()) == null) {
            transformer = this.getTemplates().newTransformer();
            this.m_stylesheet.set(transformer);
        }
        return (Transformer)transformer;
    }

    public Properties getOutputProperties() {
        return this.getTemplates().getOutputProperties();
    }

    private static synchronized void createFactories() {
        TransformerFactory tfact = (TransformerFactory)s_transformerFactory.get();
        if (tfact == null) {
            tfact = TransformerFactory.newInstance();
            if (Stylesheet.usingXSLTC()) {
                tfact.setAttribute("disable-inlining", new Boolean(true));
                s_cat.info((Object)"set disable-inlining to true for XSLSTC");
            }
            s_transformerFactory.set(tfact);
        }
        if (s_dbFactory == null) {
            s_dbFactory = DocumentBuilderFactory.newInstance();
            s_dbFactory.setNamespaceAware(true);
        }
    }

    private static org.w3c.dom.Document composeStylesheet(org.w3c.dom.Document[] stylesheetList) {
        Stylesheet.createFactories();
        org.w3c.dom.Document result = null;
        try {
            result = s_dbFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            s_cat.error((Object)"error in Stylesheet", (Throwable)e);
        }
        Element stylesheetElement = result.createElementNS(XSL_NAMESPACE_URI, "xsl:stylesheet");
        result.appendChild(stylesheetElement);
        for (int j = 0; j < stylesheetList.length; ++j) {
            int i;
            org.w3c.dom.Document thisSS = stylesheetList[j];
            NodeList nl = thisSS.getElementsByTagNameNS(XSL_NAMESPACE_URI, "stylesheet");
            if (nl == null) {
                s_cat.error((Object)"badly formed stylesheet, missing xsl:stylesheet");
                return result;
            }
            Node n = nl.item(0);
            if (n == null) {
                s_cat.error((Object)"badly formed stylesheet, missing xsl:stylesheet");
                return result;
            }
            NamedNodeMap ssAttributes = n.getAttributes();
            for (i = 0; i < ssAttributes.getLength(); ++i) {
                Attr attr = (Attr)ssAttributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (name.equals("exclude-result-prefixes")) {
                    String oldValue = stylesheetElement.getAttribute(name);
                    StringTokenizer st = new StringTokenizer(oldValue);
                    boolean duplicate = false;
                    while (st.hasMoreTokens()) {
                        if (!st.nextToken().equals(value)) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        if (oldValue != null && oldValue.length() > 0) {
                            value = value + " " + oldValue;
                        }
                    } else {
                        value = oldValue;
                    }
                }
                stylesheetElement.setAttribute(name, value);
            }
            nl = n.getChildNodes();
            block5: for (i = 0; i < nl.getLength(); ++i) {
                Node tmp;
                Node thisNode = nl.item(i);
                NodeList existingRules = stylesheetElement.getChildNodes();
                if (existingRules != null) {
                    for (int z = 0; z < existingRules.getLength(); ++z) {
                        Node testNode = existingRules.item(z);
                        if (!Stylesheet.duplicateTemplateRule(thisNode, testNode)) continue;
                        stylesheetElement.removeChild(testNode);
                    }
                }
                if ((tmp = result.importNode(thisNode, true)).getNodeName().equals("xsl:import")) {
                    NodeList tmpNodeList = stylesheetElement.getChildNodes();
                    for (int ii = 0; ii < tmpNodeList.getLength(); ++ii) {
                        Node testForTemplate = tmpNodeList.item(ii);
                        if (!testForTemplate.getNodeName().equals("xsl:template")) continue;
                        stylesheetElement.insertBefore(tmp, testForTemplate);
                        continue block5;
                    }
                    continue;
                }
                stylesheetElement.appendChild(tmp);
            }
        }
        return result;
    }

    private static boolean duplicateTemplateRule(Node node1, Node node2) {
        String nodeName1 = node1.getNodeName();
        String nodeName2 = node2.getNodeName();
        if ("xsl:template".equals(nodeName1) && "xsl:template".equals(nodeName2) && node1 instanceof Element && node2 instanceof Element) {
            Element e1 = (Element)node1;
            Element e2 = (Element)node2;
            String match1 = e1.getAttribute("match");
            String match2 = e2.getAttribute("match");
            String name1 = e1.getAttribute("name");
            String name2 = e2.getAttribute("name");
            if (name1 != null && name1.length() > 0 ? name1.equals(name2) : match1.equals(match2)) {
                return true;
            }
        }
        return false;
    }

    public static Stylesheet createStylesheet(String path) {
        Stylesheet sheet = new Stylesheet();
        sheet.setPath(path);
        sheet.save();
        return sheet;
    }

    public static Stylesheet createStylesheet(String path, Locale locale) {
        Stylesheet sheet = new Stylesheet();
        sheet.setPath(path);
        sheet.setLocale(locale);
        sheet.save();
        return sheet;
    }

    public String toString() {
        if (this.m_stylesheetDOM == null) {
            if (this.m_fileSources != null && this.m_fileSources.size() > 0) {
                String path = ((FileSource)this.m_fileSources.get(0)).getName();
                return "[contents of " + path + "]";
            }
            return "null Stylesheet";
        }
        return Document.toString(this.m_stylesheetDOM);
    }

    public static String getDefaultOutputType() {
        return s_defaultOutputType;
    }

    public String getPrimaryStylesheetContents(ServletContext ctx) throws IOException {
        FileReader in = null;
        String path = this.getPath();
        String realPath = ctx.getRealPath(path);
        File f = new File(realPath);
        in = new FileReader(f);
        int size = (int)f.length();
        char[] data = new char[size];
        for (int chars_read = 0; chars_read < size; chars_read += in.read(data, chars_read, size - chars_read)) {
        }
        String returnstring = new String(data);
        return returnstring;
    }

    public byte[] getAllStylesheetContents(ServletContext ctx) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(baos);
        ArrayList<File> l = new ArrayList<File>();
        String path = this.getPath();
        String realPath = ctx.getRealPath(path);
        File file = new File(realPath);
        l.add(file);
        this.importRecurseHelper(file, l, jos, true);
        jos.finish();
        return baos.toByteArray();
    }

    public List getStylesheetList(ServletContext ctx) throws IOException {
        ArrayList<File> l = new ArrayList<File>();
        String path = this.getPath();
        String realPath = ctx.getRealPath(path);
        File file = new File(realPath);
        l.add(file);
        this.importRecurseHelper(file, l, null, true);
        return l;
    }

    public List getImports() {
        FileSource fs = (FileSource)this.m_fileSources.get(0);
        ResourceManager rm = ResourceManager.getInstance();
        ServletContext sctx = rm.getServletContext();
        File file = new File(sctx.getRealPath(fs.getName()));
        ArrayList result = new ArrayList();
        try {
            this.importRecurseHelper(file, result, null, true);
        }
        catch (IOException ioe) {
            s_cat.error((Object)"getImports", (Throwable)ioe);
        }
        return result;
    }

    private void importRecurseHelper(File file, List l, JarOutputStream jos, boolean isFirst) throws IOException {
        String line;
        Perl5Util re = new Perl5Util();
        ResourceManager rm = ResourceManager.getInstance();
        String root = rm.getWebappRoot().getCanonicalPath();
        if (jos != null) {
            String entryName = file.getCanonicalPath().substring(root.length() + 1);
            JarEntry jent = new JarEntry(entryName);
            jos.putNextEntry(jent);
        }
        BufferedReader bufRead = new BufferedReader(new FileReader(file));
        ArrayList<File> recurselist = new ArrayList<File>();
        while ((line = bufRead.readLine()) != null) {
            if (re.match("m$<xsl:import\\s+href=\"([^\"]+)\"[^>]*>$", line)) {
                String href = re.group(1);
                File newFile = new File(file.getParent(), href);
                String canonical = newFile.getCanonicalPath();
                boolean dup = false;
                for (int i = 0; i < l.size(); ++i) {
                    File testFile = (File)l.get(i);
                    if (!canonical.equals(testFile.getCanonicalPath())) continue;
                    dup = true;
                    break;
                }
                if (!dup) {
                    l.add(newFile);
                    recurselist.add(newFile);
                }
            }
            if (jos == null) continue;
            jos.write(line.getBytes());
            jos.write("\n".getBytes());
        }
        bufRead.close();
        if (jos != null) {
            jos.closeEntry();
        }
        Iterator i = recurselist.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            this.importRecurseHelper(f, l, jos, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_transformerFactory = new ThreadLocal();
        s_ttl = 30000L;
    }

    public static class FileSource {
        private String m_name;
        private boolean m_valid = false;

        public FileSource(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void makeValid() {
            this.m_valid = true;
        }

        public boolean isValid() {
            return this.m_valid;
        }
    }
}

