/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel;

import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class Role
extends DomainObject {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/Role.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.kernel.Role";
    private Group m_sourceGroup;
    private Group m_roleGroup;
    private static final String ROLE_ID = "roleId";
    private static final String NAME = "name";
    private static final String GROUP = "sourceGroup";
    private static final String DESCRIPTION = "description";
    private static final String IMPLICIT_GROUP = "implicitGroup";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    Role(Group group, String roleName) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setGroup(group);
        this.setName(roleName);
    }

    public Role(DataObject dataObject) {
        super(dataObject);
    }

    public Role(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Role(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected void initialize() {
        super.initialize();
        if (this.getID() == null) {
            try {
                this.setID(Sequences.getNextValue());
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
        }
    }

    private void setID(BigDecimal id) {
        this.set(ROLE_ID, id);
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ROLE_ID);
    }

    public void setName(String name) {
        this.set(NAME, name);
        DataObject obj = (DataObject)this.get(IMPLICIT_GROUP);
        if (obj == null) {
            this.m_roleGroup = new Group();
            this.m_roleGroup.addSupergroup(this.getSourceGroup());
            this.setAssociation(IMPLICIT_GROUP, this.m_roleGroup);
        } else {
            this.initializeRoleGroup();
        }
        this.m_roleGroup.setName(this.getSourceGroup().getName() + " " + name);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    private void setGroup(Group group) {
        this.setAssociation(GROUP, group);
    }

    private Group getSourceGroup() {
        if (this.m_sourceGroup == null) {
            this.m_sourceGroup = new Group((DataObject)this.get(GROUP));
        }
        return this.m_sourceGroup;
    }

    public UserCollection getMemberUsers() {
        return this.getContainedUsers();
    }

    public UserCollection getContainedUsers() {
        this.initializeRoleGroup();
        return this.m_roleGroup.getMemberUsers();
    }

    public GroupCollection getContainedGroups() {
        this.initializeRoleGroup();
        return this.m_roleGroup.getSubgroups();
    }

    public PartyCollection getContainedParties() {
        this.initializeRoleGroup();
        return this.m_roleGroup.getContainedParties();
    }

    public void add(Party party) {
        this.initializeRoleGroup();
        if (party instanceof User) {
            this.m_roleGroup.addMember((User)party);
        } else if (party instanceof Group) {
            this.m_roleGroup.addSubgroup((Group)party);
        }
    }

    public void remove(Party party) {
        this.initializeRoleGroup();
        if (party instanceof User) {
            this.m_roleGroup.removeMember((User)party);
        } else if (party instanceof Group) {
            this.m_roleGroup.removeSubgroup((Group)party);
        }
    }

    public void addMember(User user) {
        this.add(user);
    }

    public void removeMember(User user) {
        this.remove(user);
    }

    private void initializeRoleGroup() {
        if (this.m_roleGroup == null) {
            DataObject obj = (DataObject)this.get(IMPLICIT_GROUP);
            if (obj == null) {
                throw new RuntimeException("There is no implicit group set up for the role named \"" + this.getName() + ".\" You probably forgot to call save() " + "prior to adding members to this role");
            }
            this.m_roleGroup = new Group(obj);
        }
    }

    protected void beforeSave() {
        if (this.m_roleGroup != null) {
            this.m_roleGroup.save();
        }
        super.beforeSave();
    }

    public void delete() throws PersistenceException {
        this.deleteRoleGroup();
        super.delete();
    }

    private void deleteRoleGroup() {
        DataObject obj = (DataObject)this.get(IMPLICIT_GROUP);
        if (obj != null) {
            this.initializeRoleGroup();
            UserCollection members = this.m_roleGroup.getAllMemberUsers();
            while (members.next()) {
                this.m_roleGroup.removeMember(members.getUser());
            }
            GroupCollection subgroups = this.m_roleGroup.getAllSubgroups();
            while (subgroups.next()) {
                this.m_roleGroup.removeSubgroup(subgroups.getGroup());
            }
            this.m_roleGroup.save();
            Group sourceGroup = this.getSourceGroup();
            this.m_roleGroup.removeSupergroup(sourceGroup);
            this.m_roleGroup.save();
            this.m_roleGroup.delete();
        }
    }

    public void grantPermission(ACSObject target, PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        PermissionService.grantPermission(new PermissionDescriptor(priv, target, this.m_roleGroup));
    }

    public void grantPermission(PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        this.grantPermission(this.m_roleGroup, priv);
    }

    public boolean checkPermission(ACSObject target, PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        return PermissionService.checkPermission(new PermissionDescriptor(priv, target, this.m_roleGroup));
    }

    public boolean checkPermission(PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        return this.checkPermission(this.m_roleGroup, priv);
    }

    public void revokePermission(ACSObject target, PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        PermissionService.revokePermission(new PermissionDescriptor(priv, target, this.m_roleGroup));
    }

    public void revokePermission(PrivilegeDescriptor priv) {
        this.initializeRoleGroup();
        this.revokePermission(this.m_roleGroup, priv);
    }

    public Group getGroup() {
        this.initializeRoleGroup();
        return this.m_roleGroup;
    }
}

