/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.globalization;

import com.arsdigita.globalization.GlobalizationException;
import com.arsdigita.globalization.MessageCatalog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class MixedResourceBundle
extends ResourceBundle {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/MixedResourceBundle.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$globalization$MixedResourceBundle == null ? (class$com$arsdigita$globalization$MixedResourceBundle = MixedResourceBundle.class$("com.arsdigita.globalization.MixedResourceBundle")) : class$com$arsdigita$globalization$MixedResourceBundle).getName());
    private Map m_contents = null;
    private Date m_lastLoaded = null;
    private Date m_lastModified = null;
    static /* synthetic */ Class class$com$arsdigita$globalization$MixedResourceBundle;

    public final Object handleGetObject(String key) {
        if (this.m_contents == null || this.isModified()) {
            this.loadContents();
        }
        return this.m_contents.get(key);
    }

    public Enumeration getKeys() {
        Enumeration keys = null;
        if (this.m_contents == null || this.isModified()) {
            this.loadContents();
        }
        if (this.parent == null) {
            keys = new Hashtable(this.m_contents).keys();
        } else {
            final Enumeration myKeys = new Hashtable(this.m_contents).keys();
            final Enumeration<String> parentKeys = this.parent.getKeys();
            keys = new Enumeration(){
                Object element = null;

                public boolean hasMoreElements() {
                    if (this.element == null) {
                        this.nextElement();
                    }
                    return this.element != null;
                }

                public Object nextElement() {
                    Object rv = this.element;
                    if (myKeys.hasMoreElements()) {
                        this.element = myKeys.nextElement();
                    } else {
                        this.element = null;
                        while (this.element == null && parentKeys.hasMoreElements()) {
                            this.element = parentKeys.nextElement();
                            if (!MixedResourceBundle.this.m_contents.containsKey(this.element)) continue;
                            this.element = null;
                        }
                    }
                    return rv;
                }
            };
        }
        return keys;
    }

    private void loadContents() {
        HashMap contents = new HashMap();
        this.setLastLoaded();
        contents.putAll(this.loadPropertyResources());
        contents.putAll(this.loadMessageCatalogResources());
        this.setLastLoaded(this.lastModified());
        if (s_cat.isDebugEnabled()) {
            s_cat.debug((Object)("Loaded " + contents.size() + " resources."));
        }
        this.m_contents = contents;
    }

    private Map loadPropertyResources() {
        String className;
        HashMap<String, String> contents;
        block9: {
            contents = new HashMap<String, String>();
            className = this.getClassName().replace('.', '/');
            URL propertiesURL = this.getClass().getClassLoader().getResource(className + ".properties");
            if (s_cat.isDebugEnabled()) {
                s_cat.debug((Object)"Starting to load static resources.");
            }
            try {
                Properties propertiesFile = new Properties();
                if (s_cat.isDebugEnabled()) {
                    s_cat.debug((Object)("Searching for a properties file called " + className + ".properties"));
                }
                if (propertiesURL == null) {
                    throw new FileNotFoundException();
                }
                propertiesFile.load(propertiesURL.openStream());
                Enumeration<?> properties = propertiesFile.propertyNames();
                while (properties.hasMoreElements()) {
                    String key = (String)properties.nextElement();
                    contents.put(key, propertiesFile.getProperty(key));
                }
                this.setLastModified(new Date(new File(propertiesURL.getFile()).lastModified()));
            }
            catch (FileNotFoundException fnfe) {
                this.setLastModified(new Date());
                File file = new File(className + ".properties");
                if (s_cat.isDebugEnabled()) {
                    s_cat.debug((Object)("Did not find " + file.getAbsolutePath()));
                }
            }
            catch (IOException ioe) {
                this.setLastModified(new Date());
                if (!s_cat.isDebugEnabled()) break block9;
                s_cat.debug((Object)("Unable to load " + className + ".properties"));
            }
        }
        if (s_cat.isInfoEnabled()) {
            s_cat.info((Object)("Loaded " + contents.size() + " resources from " + className + ".properties"));
        }
        return contents;
    }

    private Map loadMessageCatalogResources() {
        Map contents = null;
        String className = this.getClassName();
        String bundleName = this.getBundleName();
        Locale locale = this.getLocaleFromClassName();
        MessageCatalog catalog = null;
        if (s_cat.isDebugEnabled()) {
            s_cat.debug((Object)"Starting to load dynamic resources.");
        }
        try {
            catalog = locale == null ? MessageCatalog.retrieve(bundleName) : MessageCatalog.retrieve(bundleName, locale);
        }
        catch (GlobalizationException ge) {
            this.setLastModified(new Date());
            return new HashMap();
        }
        contents = catalog.getMap();
        this.setLastModified(catalog.getLastModified());
        if (s_cat.isDebugEnabled()) {
            s_cat.debug((Object)("Loaded " + contents.size() + " resources from the " + className + " MessageCatalog"));
        }
        return contents;
    }

    private boolean isModified() {
        return this.lastModified().compareTo(this.lastLoaded()) > 0;
    }

    private Date lastLoaded() {
        return this.m_lastLoaded;
    }

    private void setLastLoaded() {
        this.m_lastLoaded = new Date();
    }

    private void setLastLoaded(Date date) {
        this.m_lastLoaded = date;
    }

    private Date lastModified() {
        return this.m_lastModified;
    }

    private void setLastModified(Date date) {
        if (this.m_lastModified == null || this.m_lastModified.compareTo(date) < 0) {
            this.m_lastModified = date;
        }
    }

    private String getClassName() {
        if (s_cat.isDebugEnabled()) {
            s_cat.debug((Object)("This ResourceBundle is named " + this.getClass().getName()));
        }
        return this.getClass().getName();
    }

    private String getBundleName() {
        StringTokenizer st = new StringTokenizer(this.getClassName(), "_");
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        throw new IllegalStateException();
    }

    private Locale getLocaleFromClassName() {
        StringTokenizer st = new StringTokenizer(this.getClassName(), "_");
        Locale locale = null;
        int n_tokens = st.countTokens();
        if (n_tokens > 1) {
            st.nextToken();
            if (n_tokens == 2) {
                locale = new Locale(st.nextToken(), "");
            } else if (n_tokens == 3) {
                locale = new Locale(st.nextToken(), st.nextToken());
            } else if (n_tokens == 4) {
                locale = new Locale(st.nextToken(), st.nextToken(), st.nextToken());
            }
        }
        return locale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

