/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.formbuilder.FormBuilderDispatcher;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.parameters.PersistentParameterListener;
import com.arsdigita.formbuilder.ui.TemplatePage;
import com.arsdigita.formbuilder.util.FormBuilderConfig;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FormBuilderUtil {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/FormBuilderUtil.java#17 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$util$FormBuilderUtil == null ? (class$com$arsdigita$formbuilder$util$FormBuilderUtil = FormBuilderUtil.class$("com.arsdigita.formbuilder.util.FormBuilderUtil")) : class$com$arsdigita$formbuilder$util$FormBuilderUtil));
    public static final String FORMBUILDER_XML_NS = "http://www.arsdigita.com/formbuilder/1.0";
    public static final String FORMBUILDER_FORM_INFO = "formbuilder:formInfo";
    public static final String FORMBUILDER_PAGE_STATE = "formbuilder:pageState";
    public static final String FORM_ACTION = "formAction";
    private static final FormBuilderConfig s_config = new FormBuilderConfig();
    static /* synthetic */ Class class$com$arsdigita$formbuilder$util$FormBuilderUtil;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static FormBuilderConfig getConfig() {
        return s_config;
    }

    public static void addTextFieldToForm(FormSection form, String name, String label) {
        form.add(new Label(label));
        form.add(new TextField(name));
    }

    public static void addTextAreaToForm(FormSection form, String name, String label) {
        form.add(new Label(label));
        form.add(new TextArea(name));
    }

    public static void redirect(PageState pageState, TemplatePage page) {
        FormBuilderUtil.redirect(pageState, page, "");
    }

    public static void redirect(PageState pageState, TemplatePage page, String urlParameterString) {
        FormBuilderUtil.redirect(pageState, page.getRelativeURL() + "?" + urlParameterString);
    }

    public static void redirect(PageState pageState, String url) {
        throw new RedirectSignal(url, true);
    }

    public static boolean classImplementsInterface(Class testClass, Class interfaceClass) {
        Class<?>[] classInterfaces = testClass.getInterfaces();
        for (int i = 0; i < classInterfaces.length; ++i) {
            if (!interfaceClass.getName().equals(classInterfaces[i].getName())) continue;
            return true;
        }
        return false;
    }

    public static Class loadClass(String className) {
        Class<?> returnClass = null;
        try {
            returnClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedWrapperException(e);
        }
        return returnClass;
    }

    public static Object invokeMethod(Method method, Object object, Object[] argumentList) {
        try {
            return method.invoke(object, argumentList);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static Object instantiateObject(String className) {
        return FormBuilderUtil.instantiateObject(className, new Class[0], new Object[0]);
    }

    public static PersistentComponentFactory instantiateFactory(BigDecimal componentID) {
        Session session = SessionManager.getSession();
        String factoryClassName = null;
        OID oid = new OID("com.arsdigita.formbuilder.Component", (Object)componentID);
        DataObject componentObject = session.retrieve(oid);
        if (componentObject == null) {
            throw new RuntimeException("could not retrieve DataObject with id " + oid.toString());
        }
        factoryClassName = (String)componentObject.get("defaultDomainClass");
        return (PersistentComponentFactory)FormBuilderUtil.instantiateObjectOneArg(factoryClassName, componentID);
    }

    public static ACSObject instantiateObject(BigDecimal id) {
        s_log.info((Object)("instantiate object with id " + id));
        OID oid = new OID("com.arsdigita.kernel.ACSObject", (Object)id);
        Session s = SessionManager.getSession();
        DataObject o = s.retrieve(oid);
        ACSObject obj = (ACSObject)FormBuilderUtil.instantiateObject((String)o.get("defaultDomainClass"), new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = FormBuilderUtil.class$("java.math.BigDecimal")) : class$java$math$BigDecimal}, new Object[]{id});
        return obj;
    }

    public static Object instantiateObjectOneArg(String className, Object arg) {
        s_log.info((Object)("instantiate object class " + className + " arg class " + arg.getClass()));
        RuntimeException exn = null;
        for (Class<?> argClass = arg.getClass(); argClass != null; argClass = argClass.getSuperclass()) {
            try {
                return FormBuilderUtil.instantiateObject(className, new Class[]{argClass}, new Object[]{arg});
            }
            catch (RuntimeException e) {
                exn = e;
                continue;
            }
        }
        throw exn;
    }

    public static Object instantiateObject(String className, Class[] argumentTypes, Object[] arguments) {
        Object object;
        s_log.debug((Object)("instantiate object class " + className + " args " + argumentTypes));
        try {
            Class<?> classObject = Class.forName(className);
            Constructor<?> constructor = classObject.getConstructor(argumentTypes);
            object = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException(e);
        }
        return object;
    }

    public static void assertArgumentInRange(int argument, int lowerLimit, int upperLimit) {
        boolean argumentIsValid = true;
        if (argument < lowerLimit) {
            argumentIsValid = false;
        }
        if (argument > upperLimit) {
            argumentIsValid = false;
        }
        if (!argumentIsValid) {
            throw new IllegalArgumentException("Integer argument with value " + argument + " is out of range. Should be between " + lowerLimit + " and " + upperLimit);
        }
    }

    public static Link createIndexLink() {
        return new Link((Component)new Label(GlobalizationUtil.globalize("formbuilder.util.return_to_index_page")), "index" + FormBuilderDispatcher.getURLEnding());
    }

    public static boolean isSuccessfulSubmission(FormData formData) {
        return formData.isSubmission() && !formData.getAllErrors().hasNext();
    }

    public static boolean isRequired(PersistentWidget widget) {
        Iterator listenerIter = widget.getValidationListeners().iterator();
        while (listenerIter.hasNext()) {
            PersistentParameterListener listener = (PersistentParameterListener)listenerIter.next();
            if (!listener.getClassName().equals("com.arsdigita.bebop.parameters.NotEmptyValidationListener")) continue;
            return true;
        }
        return false;
    }

    public static void doLogDebug(Logger log, String message) {
        log.debug((Object)message, (Throwable)new Exception());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load("ccm-core/formbuilder.properties");
    }
}

