/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentText;
import com.arsdigita.formbuilder.ui.PropertiesForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class TextForm
extends PropertiesForm
implements FormInitListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$ui$editors$TextForm == null ? (class$com$arsdigita$formbuilder$ui$editors$TextForm = TextForm.class$("com.arsdigita.formbuilder.ui.editors.TextForm")) : class$com$arsdigita$formbuilder$ui$editors$TextForm));
    private Widget m_text;
    private SingleSelectionModel m_action;
    private SingleSelectionModel m_form;
    static /* synthetic */ Class class$com$arsdigita$formbuilder$ui$editors$TextForm;

    public TextForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name);
        this.m_action = action;
        this.m_form = form;
        this.addProcessListener(this);
        this.addInitListener(this);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_text = this.getTextWidget(new StringParameter("text"));
        this.m_text.addValidationListener(new NotEmptyValidationListener());
        section.add(new Label(this.getTextTitle()), 4);
        section.add(this.m_text);
    }

    protected Widget getTextWidget(StringParameter parameter) {
        return new TextArea(parameter);
    }

    protected GlobalizedMessage getTextTitle() {
        return GlobalizationUtil.globalize("formbuilder.ui.editors.text_form_title");
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        BigDecimal action = (BigDecimal)this.m_action.getSelectedKey(state);
        if (action != null) {
            try {
                PersistentText text = this.getPersistentText(action);
                this.m_text.setValue(state, text.getText());
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)("Unable to find Persistent Text for id " + action), (Throwable)ex);
            }
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (this.isCancelled(state)) {
            return;
        }
        PersistentText text = this.getPersistentText(state);
        String textString = (String)this.m_text.getValue(state);
        text.setText(textString);
        text.save();
        BigDecimal action = (BigDecimal)this.m_action.getSelectedKey(state);
        if (action == null) {
            this.addToForm(e, text);
        }
    }

    protected void addToForm(FormSectionEvent e, PersistentText widget) throws FormProcessException {
        BigDecimal form_id = (BigDecimal)this.m_form.getSelectedKey(e.getPageState());
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(form_id);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("cannot find form", ex);
        }
        form.addComponent(widget);
        form.save();
    }

    protected PersistentText getPersistentText() {
        return new PersistentText();
    }

    protected PersistentText getPersistentText(BigDecimal id) throws DataObjectNotFoundException {
        return new PersistentText(id);
    }

    protected PersistentText getPersistentText(PageState state) {
        BigDecimal action = (BigDecimal)this.m_action.getSelectedKey(state);
        if (action != null) {
            try {
                return this.getPersistentText(action);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)("Unable to find Persistent Text for id " + action), (Throwable)ex);
                throw new UncheckedWrapperException("cannot find Persistent Text for id " + action, ex);
            }
        }
        return this.getPersistentText();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

