/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentProcessListener;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Iterator;

public class ProcessListenerTableModelBuilder
extends AbstractTableModelBuilder {
    SingleSelectionModel m_selection;

    public ProcessListenerTableModelBuilder(SingleSelectionModel selection) {
        this.m_selection = selection;
    }

    public TableModel makeModel(Table table, PageState state) {
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection((BigDecimal)this.m_selection.getSelectedKey(state));
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
            throw new UncheckedWrapperException(ex);
        }
        return new PersistentFormTableModel(form.getProcessListeners());
    }

    private class PersistentFormTableModel
    implements TableModel {
        private Iterator m_listeners;
        private PersistentProcessListener listener;

        public PersistentFormTableModel(Iterator listeners) {
            this.m_listeners = listeners;
        }

        public boolean nextRow() {
            if (this.m_listeners.hasNext()) {
                this.listener = (PersistentProcessListener)this.m_listeners.next();
                return true;
            }
            return false;
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getKeyAt(int columnIndex) {
            return this.listener.getID();
        }

        public Object getElementAt(int columnIndex) {
            return this.listener;
        }
    }
}

