/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.formbuilder.FormBuilderDispatcher;
import com.arsdigita.formbuilder.PersistentOption;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.formbuilder.ui.FormBuildingPage;
import com.arsdigita.formbuilder.ui.TemplatePage;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OptionGroupPage
extends TemplatePage {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/OptionGroupPage.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$ui$FormBuildingPage == null ? (class$com$arsdigita$formbuilder$ui$FormBuildingPage = OptionGroupPage.class$("com.arsdigita.formbuilder.ui.FormBuildingPage")) : class$com$arsdigita$formbuilder$ui$FormBuildingPage));
    private static OptionGroupPage s_instance;
    private OptionGroup m_defaultOptionGroup;
    public BigDecimalParameter m_formID;
    public BigDecimalParameter m_widgetID;
    public StringParameter m_widgetClass;
    public IntegerParameter m_nOptions;
    public StringParameter m_pageMode;
    private static final String PERSISTENT_WIDGET_PREFIX = "com.arsdigita.formbuilder.Persistent";
    private static final int PERSISTENT_WIDGET_PREFIX_LENGTH;
    RequestLocal m_optionGroup = new RequestLocal(){

        public Object initialValue(PageState pageState) {
            String widgetID = OptionGroupPage.this.getWidgetID(pageState).toString();
            return (PersistentOptionGroup)FormBuilderUtil.instantiateObjectOneArg(OptionGroupPage.this.getWidgetClass(pageState), new BigDecimal(widgetID));
        }
    };
    static /* synthetic */ Class class$com$arsdigita$formbuilder$ui$FormBuildingPage;

    private OptionGroupPage() {
        super(OptionGroupPage.getStaticTitle());
    }

    public static OptionGroupPage instance() {
        if (s_instance == null) {
            s_instance = new OptionGroupPage();
        }
        return s_instance;
    }

    public static String getStaticTitle() {
        return "Specify Options for the OptionGroup";
    }

    public String getRelativeURL() {
        return "options-specify" + FormBuilderDispatcher.getURLEnding();
    }

    protected void buildPage() {
        this.add(FormBuilderUtil.createIndexLink());
        this.setupGlobalStateParameters();
        this.setDynamicTitle();
        this.add(this.getOptionsForm());
        this.add(FormBuilderUtil.createIndexLink());
    }

    private void setupGlobalStateParameters() {
        this.m_formID = new BigDecimalParameter("form_id");
        this.m_widgetID = new BigDecimalParameter("widget_id");
        this.m_widgetClass = new StringParameter("widget_class");
        this.m_nOptions = new IntegerParameter("n_options");
        this.m_pageMode = new StringParameter("page_mode");
        this.addGlobalStateParam(this.m_formID);
        this.addGlobalStateParam(this.m_widgetID);
        this.addGlobalStateParam(this.m_widgetClass);
        this.addGlobalStateParam(this.m_nOptions);
        this.addGlobalStateParam(this.m_pageMode);
    }

    private void setDynamicTitle() {
        Label titleLabel = new Label(GlobalizationUtil.globalize("formbuilder.ui.specify_options"));
        titleLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label inner_titleLabel = (Label)e.getTarget();
                String className = OptionGroupPage.this.getWidgetClass(e.getPageState()).substring(PERSISTENT_WIDGET_PREFIX_LENGTH);
                inner_titleLabel.setLabel("Specify Options for the " + className);
            }
        });
        this.setTitle(titleLabel);
    }

    private MetaForm getOptionsForm() {
        return new OptionsForm("specify_options");
    }

    public BigDecimal getFormID(PageState pageState) {
        return (BigDecimal)pageState.getValue(this.m_formID);
    }

    public BigDecimal getWidgetID(PageState pageState) {
        return (BigDecimal)pageState.getValue(this.m_widgetID);
    }

    public String getWidgetClass(PageState pageState) {
        return (String)pageState.getValue(this.m_widgetClass);
    }

    public Integer getNOptions(PageState pageState) {
        return (Integer)pageState.getValue(this.m_nOptions);
    }

    private FormProcessListener getProcessListener() {
        return new FormProcessListener(){

            public void process(FormSectionEvent formEvent) {
                FormData formData = formEvent.getFormData();
                PageState pageState = formEvent.getPageState();
                int nOptions = OptionGroupPage.this.getNOptions(pageState);
                String formID = OptionGroupPage.this.getFormID(pageState).toString();
                Object defaultOption = formData.get("defaultSelection");
                PersistentOptionGroup optionGroup = OptionGroupPage.this.getOptionGroup(pageState);
                String pageMode = OptionGroupPage.this.getPageMode(pageState);
                if (pageMode.equals("add") || pageMode.equals("parameter")) {
                    for (int i = 1; i <= nOptions; ++i) {
                        String optionValue = formData.getString("value" + i);
                        String optionLabel = formData.getString("label" + i);
                        PersistentOption option = PersistentOption.create(optionValue, optionLabel);
                        optionGroup.addOption(option);
                        if (!this.isSelected(i, defaultOption)) continue;
                        optionGroup.setOptionSelected(option, true);
                    }
                } else if (pageMode.equals("edit")) {
                    Iterator optionIter = optionGroup.getOptions().iterator();
                    int counter = 1;
                    while (optionIter.hasNext()) {
                        PersistentOption option = (PersistentOption)optionIter.next();
                        String optionValue = formData.getString("value" + counter);
                        String optionLabel = formData.getString("label" + counter);
                        option.setParameterValue(optionValue);
                        option.setLabel(optionLabel);
                        option.save();
                        ++counter;
                    }
                }
                optionGroup.save();
                String urlParameterString = "form_id=" + formID;
                FormBuilderUtil.redirect(pageState, FormBuildingPage.instance(), urlParameterString);
            }

            private boolean isSelected(int optionNumber, Object defaultSelection) {
                String numberString = Integer.toString(optionNumber);
                if (defaultSelection == null) {
                    return false;
                }
                if (defaultSelection instanceof String) {
                    return ((String)defaultSelection).equals(numberString);
                }
                Object[] selectionArray = (Object[])defaultSelection;
                for (int i = 0; i < selectionArray.length; ++i) {
                    if (!((String)selectionArray[i]).equals(numberString)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private String getPageMode(PageState pageState) {
        return (String)pageState.getValue(this.m_pageMode);
    }

    private PersistentOptionGroup getOptionGroup(PageState pageState) {
        return (PersistentOptionGroup)this.m_optionGroup.get(pageState);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PERSISTENT_WIDGET_PREFIX_LENGTH = PERSISTENT_WIDGET_PREFIX.length();
    }

    private class OptionsForm
    extends MetaForm {
        RequestLocal m_isMultipleChoice = new RequestLocal(this){
            private final /* synthetic */ OptionsForm this$1;
            {
                this.this$1 = this$1;
            }

            public Object initialValue(PageState pageState) {
                String className = OptionsForm.access$100(this.this$1).getWidgetClass(pageState);
                PersistentOptionGroup optionGroup = (PersistentOptionGroup)FormBuilderUtil.instantiateObject(className);
                return new Boolean(optionGroup.isMultiple());
            }
        };

        public OptionsForm(String name) {
            super(name);
        }

        public Form buildForm(PageState pageState) {
            Form form = new Form("options_form", new ColumnPanel(3));
            if (this.isMultipleChoice(pageState)) {
                OptionGroupPage.this.m_defaultOptionGroup = new CheckboxGroup("defaultSelection");
            } else {
                OptionGroupPage.this.m_defaultOptionGroup = new RadioGroup("defaultSelection");
            }
            form.add(OptionGroupPage.this.m_defaultOptionGroup, 64);
            form.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.default_selection")));
            form.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.value")));
            form.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.label")));
            if (OptionGroupPage.this.getPageMode(pageState).equals("add") || OptionGroupPage.this.getPageMode(pageState).equals("parameter")) {
                String nOptions = OptionGroupPage.this.getNOptions(pageState).toString();
                for (int i = 1; i <= Integer.parseInt(nOptions); ++i) {
                    this.addOption(i, form, "", "");
                }
            } else if (OptionGroupPage.this.getPageMode(pageState).equals("edit")) {
                Iterator optionIter = OptionGroupPage.this.getOptionGroup(pageState).getOptions().iterator();
                int counter = 1;
                while (optionIter.hasNext()) {
                    PersistentOption option = (PersistentOption)optionIter.next();
                    this.addOption(counter, form, option.getParameterValue(), option.getLabel());
                    ++counter;
                }
            }
            form.add(new Submit("submit options"));
            form.addProcessListener(OptionGroupPage.this.getProcessListener());
            return form;
        }

        private void addOption(int number, Form form, String defaultValue, String defaultLabel) {
            Option defaultOption = new Option(Integer.toString(number), "");
            defaultOption.setGroup(OptionGroupPage.this.m_defaultOptionGroup);
            form.add(defaultOption);
            TextField optionValue = new TextField("value" + number);
            TextField optionLabel = new TextField("label" + number);
            optionValue.addValidationListener(new NotEmptyValidationListener());
            optionLabel.addValidationListener(new NotEmptyValidationListener());
            form.add(optionValue);
            form.add(optionLabel);
            optionValue.setDefaultValue(defaultValue);
            optionLabel.setDefaultValue(defaultLabel);
        }

        private boolean isMultipleChoice(PageState pageState) {
            return (Boolean)this.m_isMultipleChoice.get(pageState);
        }

        static /* synthetic */ OptionGroupPage access$100(OptionsForm x0) {
            return x0.OptionGroupPage.this;
        }
    }
}

