/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.WidgetLabel;
import com.arsdigita.formbuilder.ui.BaseAddObserver;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletException;

public class MoveControl
extends MetaForm {
    private SingleSelectionModel m_form;
    private SingleSelectionModel m_control;
    private ArrayList m_listeners;

    public MoveControl(SingleSelectionModel form, SingleSelectionModel control) {
        super("view_form");
        this.m_form = form;
        this.m_control = control;
        this.m_listeners = new ArrayList();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String name = state.getControlEventName();
                String value = state.getControlEventValue();
                if (name.equals("move")) {
                    Integer pos = new Integer(value);
                    BigDecimal control_id = (BigDecimal)MoveControl.this.m_control.getSelectedKey(state);
                    BigDecimal form_id = (BigDecimal)MoveControl.this.m_form.getSelectedKey(state);
                    PersistentFormSection form = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);
                    PersistentComponent control = (PersistentComponent)FormBuilderUtil.instantiateObject(control_id);
                    WidgetLabel label = null;
                    if (control instanceof PersistentWidget) {
                        try {
                            label = WidgetLabel.findByWidget((PersistentWidget)control);
                        }
                        catch (DataObjectNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    if (label != null) {
                        form.removeComponent(label);
                    }
                    form.removeComponent(control);
                    if (label != null) {
                        form.addComponent(label, pos);
                    }
                    form.addComponent(control, label == null ? pos : pos + 1);
                }
            }
        });
    }

    public Form buildForm(PageState state) {
        BigDecimal form_id = (BigDecimal)this.m_form.getSelectedKey(state);
        BigDecimal control_id = (BigDecimal)this.m_control.getSelectedKey(state);
        PersistentFormSection section = (PersistentFormSection)FormBuilderUtil.instantiateObject(form_id);
        section.setComponentAddObserver(new MoveControlObserver(this, control_id));
        try {
            PersistentForm form = (PersistentForm)section;
            return (Form)form.createComponent();
        }
        catch (ClassCastException ex) {
            Form form = new Form("view_form", new ColumnPanel(1));
            form.add((FormSection)section.createComponent());
            return form;
        }
    }

    public void addActionListener(ActionListener l) {
        this.m_listeners.add(l);
    }

    public void fireActionEvent(ActionEvent e) {
        Iterator listeners = this.m_listeners.iterator();
        while (listeners.hasNext()) {
            ActionListener l = (ActionListener)listeners.next();
            l.actionPerformed(e);
        }
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        this.fireActionEvent(new ActionEvent(this, state));
    }

    private class MoveControlObserver
    extends BaseAddObserver {
        Component m_handler;
        boolean m_before;
        boolean m_after;
        BigDecimal m_moving;
        HashSet m_seen;

        public MoveControlObserver(Component handler, BigDecimal moving) {
            this.m_handler = handler;
            this.m_before = true;
            this.m_after = false;
            this.m_moving = moving;
            this.m_seen = new HashSet();
        }

        public void beforeAddingComponent(FormSection formSection, PersistentComponentFactory componentFactory, int componentPosition) {
            super.beforeAddingComponent(formSection, componentFactory, componentPosition);
            if (componentFactory.getID().equals(this.m_moving)) {
                this.m_before = false;
            }
            if (componentFactory instanceof WidgetLabel) {
                WidgetLabel label = (WidgetLabel)componentFactory;
                BigDecimal id = label.getWidgetID();
                this.m_seen.add(id);
                if (id.equals(this.m_moving)) {
                    this.addLabel(formSection);
                    this.m_seen.add(componentFactory.getID());
                }
            }
            if (!this.m_seen.contains(componentFactory.getID()) && this.m_before) {
                this.addLink(formSection, componentPosition);
            }
        }

        public void addingComponent(PersistentComponentFactory componentFactory, int componentPosition, Component component) {
            super.addingComponent(componentFactory, componentPosition, component);
        }

        public void afterAddingComponent(FormSection formSection, PersistentComponentFactory componentFactory, int componentPosition) {
            super.afterAddingComponent(formSection, componentFactory, componentPosition);
            if (!(componentFactory instanceof WidgetLabel) && this.m_after) {
                this.addLink(formSection, componentPosition - 1);
            }
            if (componentFactory.getID().equals(this.m_moving)) {
                this.m_after = true;
                this.addLabel(formSection);
            }
        }

        protected void addLabel(FormSection form) {
            Label l = new Label(GlobalizationUtil.globalize("formbuilder.ui.move_it_here"));
            form.add(l, 64);
        }

        protected void addLink(FormSection form, int row) {
            MoveLink l = new MoveLink("[move it here]", row);
            form.add(l, 64);
        }

        private class MoveLink
        extends ControlLink {
            int m_row;

            public MoveLink(String name, int row) {
                super(name);
                this.m_row = row;
            }

            public void setControlEvent(PageState state) {
                state.setControlEvent(MoveControlObserver.this.m_handler, "move", new Integer(this.m_row).toString());
            }
        }
    }
}

