/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.db;

import com.arsdigita.db.DbUnsupportedException;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DbHelper {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$db$DbHelper == null ? (class$com$arsdigita$db$DbHelper = DbHelper.class$("com.arsdigita.db.DbHelper")) : class$com$arsdigita$db$DbHelper));
    public static final int DB_DEFAULT = 0;
    public static final int DB_ORACLE = 1;
    public static final int DB_POSTGRES = 2;
    public static final int DB_MAX = 2;
    private static int s_database = 0;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String[] DB_SUFFIXES = new String[]{"ora", "pg"};
    static /* synthetic */ Class class$com$arsdigita$db$DbHelper;

    private DbHelper() {
    }

    public static void setDatabase(int database) {
        Assert.assertTrue(database >= 0 && database <= 2);
        s_database = database;
        s_log.info((Object)("Setting database to " + DbHelper.getDatabaseName(database)));
    }

    public static int getDatabase() {
        return s_database;
    }

    public static int getDatabase(DatabaseMetaData md) {
        try {
            return DbHelper.getDatabaseFromURL(md.getURL());
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static int getDatabase(Connection conn) {
        try {
            return DbHelper.getDatabase(conn.getMetaData());
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static int getDatabase(Statement stmt) {
        try {
            return DbHelper.getDatabase(stmt.getConnection());
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static int getDatabase(ResultSet rs) {
        try {
            return DbHelper.getDatabase(rs.getStatement());
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException(e);
        }
    }

    public static String getDatabaseDirectory() {
        return DbHelper.getDatabaseDirectory(s_database);
    }

    public static String getDatabaseDirectory(int database) {
        Assert.assertTrue(database >= 0 && database <= 2);
        switch (database) {
            case 1: {
                s_log.info((Object)"ORACLE");
                return "oracle-se";
            }
            case 2: {
                s_log.info((Object)"POSTGRES");
                return "postgres";
            }
        }
        return "default";
    }

    public static String getDatabaseSuffix() {
        return DbHelper.getDatabaseSuffix(s_database);
    }

    public static String getDatabaseSuffix(int database) {
        switch (database) {
            case 1: {
                return DB_SUFFIXES[0];
            }
            case 2: {
                return DB_SUFFIXES[1];
            }
        }
        return null;
    }

    public static String[] getDatabaseSuffixes() {
        return DB_SUFFIXES;
    }

    public static int getDatabaseFromURL(String url) {
        if (!url.startsWith("jdbc:")) {
            throw new IllegalArgumentException("JDBC URL " + url + " doesn't start with jdbc:");
        }
        int pos = url.indexOf(":", 5);
        if (pos == -1) {
            throw new IllegalArgumentException("JDBC URL " + url + " is not of the form jdbc:[dbname]:xyz");
        }
        String driver = url.substring(5, pos);
        s_log.debug((Object)("Got driver name " + driver), new Throwable());
        if ("oracle".equals(driver)) {
            return 1;
        }
        if ("postgresql".equals(driver)) {
            return 2;
        }
        return 0;
    }

    public static String getDatabaseName(int database) {
        Assert.assertTrue(database >= 0 && database <= 2);
        switch (database) {
            case 1: {
                return "Oracle SE";
            }
            case 2: {
                return "PostgreSQL";
            }
        }
        return "Default";
    }

    public static void unsupportedDatabaseError(String operation) {
        throw new DbUnsupportedException("Database " + DbHelper.getDatabaseName(s_database) + " does not support " + operation);
    }

    public static int varcharLength(String str) {
        if (str == null || "".equals(str)) {
            return 1;
        }
        int result = 0;
        switch (DbHelper.getDatabase()) {
            case 2: {
                result = str.length();
                break;
            }
            case 1: {
                try {
                    result = str.getBytes(DEFAULT_ENCODING).length;
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new UncheckedWrapperException("UTF-8 not supported by JRE", ex);
                }
            }
            default: {
                DbHelper.unsupportedDatabaseError("varcharLength");
            }
        }
        if (result == 0) {
            return 1;
        }
        return result;
    }

    public static String truncateString(String s, int maxLength) {
        String result = null;
        switch (DbHelper.getDatabase()) {
            case 2: {
                result = s.substring(0, maxLength - 1);
                break;
            }
            case 1: {
                byte[] sBytes = s.getBytes();
                byte[] sTruncateBytes = new byte[maxLength];
                System.arraycopy(sBytes, 0, sTruncateBytes, 0, maxLength);
                String truncateString = new String(sTruncateBytes);
                result = truncateString.substring(0, truncateString.length() - 1);
                break;
            }
            default: {
                DbHelper.unsupportedDatabaseError("varcharLength");
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

