/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.caching;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Host;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CacheServlet
extends HttpServlet {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$caching$CacheServlet == null ? (class$com$arsdigita$caching$CacheServlet = CacheServlet.class$("com.arsdigita.caching.CacheServlet")) : class$com$arsdigita$caching$CacheServlet));
    private static final String ID = "id";
    private static final String KEY = "key";
    private static final String HASH = "hash";
    static final String SERVLET_URL = "/expireCache";
    static /* synthetic */ Class class$com$arsdigita$caching$CacheServlet;
    static /* synthetic */ Class class$com$arsdigita$caching$CacheServlet$HTTPRequester;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        String id = req.getParameter(ID);
        String key = req.getParameter(KEY);
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Got remove request from " + req.getRemoteHost()));
        }
        if (id == null || key == null) {
            return;
        }
        id = URLDecoder.decode(id);
        key = URLDecoder.decode(key);
        CacheTable cache = CacheTable.getCache(id);
        if (cache == null) {
            s_log.debug((Object)("No cache with id " + id));
            return;
        }
        s_log.debug((Object)("Removing " + key + " from cache " + id));
        String hash = req.getParameter(HASH);
        Integer hashCode = this.getHashCode(hash);
        if (hashCode == null) {
            cache.removeLocally(key);
        } else {
            cache.removeLocallyIfOutdated(key, hashCode);
        }
    }

    private Integer getHashCode(String hash) {
        if (hash == null) {
            return null;
        }
        Integer hashCode = null;
        try {
            hashCode = new Integer(hash);
        }
        catch (NumberFormatException nfe) {
            s_log.warn((Object)("format exception on hash " + hash + " : " + nfe.getMessage()));
        }
        return hashCode;
    }

    static void remove(String cache_id, String key) {
        CacheTable cache = CacheTable.getCache(cache_id);
        if (cache == null) {
            return;
        }
        cache.removeLocally(key);
        CacheServlet.removeFromPeers(cache_id, key);
    }

    static void removeFromPeers(String cache_id, String key) {
        CacheServlet.notifyPeers(cache_id, key, null);
    }

    static void removeOutdatedFromPeers(String cache_id, String key, int newHashCode) {
        CacheServlet.notifyPeers(cache_id, key, String.valueOf(newHashCode));
    }

    private static void notifyPeers(String id, String key, String hash) {
        s_log.debug((Object)"notifying peers");
        DomainCollection hosts = Host.retrieveAll();
        HttpHost current = Web.getConfig().getHost();
        hosts.addNotEqualsFilter("serverPort", new Integer(current.getPort()));
        while (hosts.next()) {
            Host host = (Host)hosts.getDomainObject();
            CacheServlet.notifyPeer(host, CacheServlet.makeParameterMap(id, key, hash));
        }
    }

    private static void notifyPeer(Host host, ParameterMap params) {
        String url = "http://" + host + SERVLET_URL + params;
        try {
            s_log.debug((Object)("sending notification to " + url));
            URL netURL = new URL(url);
            new Thread(new HTTPRequester(netURL)).start();
        }
        catch (MalformedURLException e) {
            s_log.error((Object)("malformed URL: " + url));
        }
    }

    private static ParameterMap makeParameterMap(String id, String key, String hash) {
        ParameterMap params = new ParameterMap();
        params.setParameter(ID, id);
        if (key != null) {
            params.setParameter(KEY, key);
        }
        if (hash != null) {
            params.setParameter(HASH, hash);
        }
        return params;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HTTPRequester
    implements Runnable {
        private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$caching$CacheServlet$HTTPRequester == null ? (class$com$arsdigita$caching$CacheServlet$HTTPRequester = CacheServlet.class$("com.arsdigita.caching.CacheServlet$HTTPRequester")) : class$com$arsdigita$caching$CacheServlet$HTTPRequester));
        private final URL m_url;

        public HTTPRequester(URL url) {
            this.m_url = url;
        }

        public void run() {
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Sending invalidate to " + this.m_url));
                }
                this.m_url.openStream();
            }
            catch (IOException e) {
                s_log.error((Object)("Failure sending cache invalidate: " + this.m_url), (Throwable)e);
            }
        }
    }
}

