/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.portal;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletType;
import com.arsdigita.util.UncheckedWrapperException;

public class PortletConfigFormSection
extends ResourceConfigFormSection {
    private RequestLocal m_parentResource;
    private RequestLocal m_currentResource;
    private PortletType m_portletType;
    private TextField m_title;
    private TextArea m_desc;

    public PortletConfigFormSection(ResourceType resType, RequestLocal parentAppRL) {
        this.m_portletType = (PortletType)resType;
        this.m_parentResource = parentAppRL;
        this.m_portletType.disconnect();
        this.setup();
    }

    public PortletConfigFormSection(RequestLocal application) {
        this.m_currentResource = application;
        this.setup();
    }

    private void setup() {
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (PortletConfigFormSection.this.m_currentResource != null) {
                    Portlet portlet = (Portlet)PortletConfigFormSection.this.m_currentResource.get(state);
                    PortletConfigFormSection.this.initWidgets(state, portlet);
                } else {
                    PortletConfigFormSection.this.initWidgets(state, null);
                }
            }
        });
        this.addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (PortletConfigFormSection.this.m_currentResource != null) {
                    Portlet portlet = (Portlet)PortletConfigFormSection.this.m_currentResource.get(state);
                    PortletConfigFormSection.this.validateWidgets(state, portlet);
                } else {
                    PortletConfigFormSection.this.validateWidgets(state, null);
                }
            }
        });
        this.addWidgets();
    }

    protected void addWidgets() {
        this.m_title = new TextField(new StringParameter("title"));
        this.m_title.setSize(35);
        this.m_title.addValidationListener(new NotNullValidationListener());
        this.m_title.addValidationListener(new StringInRangeValidationListener(1, 200));
        this.m_desc = new TextArea(new StringParameter("desc"));
        this.m_desc.setRows(5);
        this.m_desc.setCols(35);
        this.m_desc.addValidationListener(new StringInRangeValidationListener(0, 4000));
        this.add(new Label("Title:", "b"), 4);
        this.add(this.m_title);
        this.add(new Label("Description:", "b"), 4);
        this.add(this.m_desc);
    }

    protected void initWidgets(PageState state, Portlet portlet) throws FormProcessException {
        if (portlet != null) {
            this.m_title.setValue(state, portlet.getTitle());
            this.m_desc.setValue(state, portlet.getDescription());
        } else {
            this.m_title.setValue(state, this.m_portletType.getTitle());
            this.m_desc.setValue(state, this.m_portletType.getDescription());
        }
    }

    protected void validateWidgets(PageState state, Portlet portlet) throws FormProcessException {
    }

    public Resource createResource(PageState state) {
        Resource parent = (Resource)this.m_parentResource.get(state);
        Portlet portlet = Portlet.createPortlet(this.m_portletType, parent);
        try {
            this.processWidgets(state, portlet);
        }
        catch (FormProcessException ex) {
            throw new UncheckedWrapperException("cannot create resource", (Throwable)((Object)ex));
        }
        return portlet;
    }

    public void modifyResource(PageState state) {
        Portlet portlet = (Portlet)this.m_currentResource.get(state);
        try {
            this.processWidgets(state, portlet);
        }
        catch (FormProcessException ex) {
            throw new UncheckedWrapperException("cannot create resource", (Throwable)((Object)ex));
        }
    }

    protected void processWidgets(PageState state, Portlet portlet) throws FormProcessException {
        portlet.setTitle((String)this.m_title.getValue(state));
        portlet.setDescription((String)this.m_desc.getValue(state));
    }
}

