/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;

public class NumberInRangeValidationListener
implements ParameterListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/NumberInRangeValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final double m_lowerBound;
    private final double m_upperBound;
    private final String m_baseErrorMsg;

    public NumberInRangeValidationListener(Number a, Number b) {
        this(a.doubleValue(), b.doubleValue());
    }

    public NumberInRangeValidationListener(long lower, long upper) {
        this((double)lower, (double)upper);
    }

    public NumberInRangeValidationListener(double lower, double upper) {
        if (upper < lower) {
            throw new IllegalArgumentException("Lower bound must be less than or equal to upper bound.");
        }
        this.m_lowerBound = lower;
        this.m_upperBound = upper;
        StringBuffer msg = new StringBuffer(128);
        msg.append("The following values are out of the specified range of (").append(this.m_lowerBound).append(",").append(this.m_upperBound).append(") :");
        this.m_baseErrorMsg = msg.toString();
    }

    public void validate(ParameterEvent e) throws FormProcessException {
        ParameterData data = e.getParameterData();
        Object obj = data.getValue();
        boolean isValid = true;
        if (obj == null) {
            return;
        }
        StringBuffer msg = null;
        if (obj instanceof Number[]) {
            Number[] values = (Number[])obj;
            for (int i = 0; i < values.length; ++i) {
                double val = values[i].doubleValue();
                if (!(this.m_lowerBound > val) && !(val > this.m_upperBound)) continue;
                if (msg == null) {
                    msg = new StringBuffer(this.m_baseErrorMsg);
                }
                msg.append(val);
                msg.append(" ");
                isValid = false;
            }
        } else if (obj instanceof Number) {
            Number value = (Number)obj;
            double val = value.doubleValue();
            if (this.m_lowerBound > val || val > this.m_upperBound) {
                msg = new StringBuffer(this.m_baseErrorMsg);
                msg.append(val);
                isValid = false;
            }
        } else {
            throw new FormProcessException("Unexpected value type: " + obj.getClass());
        }
        if (!isValid) {
            data.addError(msg.toString());
        }
    }
}

