/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;

public class EnumerationValidationListener
implements ParameterListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/EnumerationValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String[] m_allowedValues;
    private final boolean m_caseSensitive;
    private final String m_baseErrorMsg;

    public EnumerationValidationListener(String[] allowedValues) {
        this(allowedValues, false);
    }

    public EnumerationValidationListener(String[] allowedValues, boolean caseSensitive) {
        this.m_allowedValues = allowedValues;
        this.m_caseSensitive = caseSensitive;
        StringBuffer msg = new StringBuffer(128);
        msg.append(" must be one of:");
        for (int j = 0; j < this.m_allowedValues.length; ++j) {
            msg.append(this.m_allowedValues[j]).append(" ");
        }
        this.m_baseErrorMsg = msg.toString();
    }

    public void validate(ParameterEvent e) {
        ParameterData data = e.getParameterData();
        if (this.m_allowedValues == null) {
            return;
        }
        if (data.getValue() instanceof Object[]) {
            String[] names = (String[])data.getValue();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (this.validateOneString(name)) continue;
                data.addError(name + this.m_baseErrorMsg);
            }
        } else {
            String name = (String)data.getValue();
            if (!this.validateOneString(name)) {
                data.addError(name + this.m_baseErrorMsg);
            }
        }
    }

    private boolean validateOneString(String value) {
        if (value == null) {
            return true;
        }
        boolean isValid = false;
        for (int j = 0; j < this.m_allowedValues.length; ++j) {
            if (this.m_caseSensitive) {
                if (!value.equals(this.m_allowedValues[j])) continue;
                isValid = true;
                break;
            }
            if (!value.equalsIgnoreCase(this.m_allowedValues[j])) continue;
            isValid = true;
            break;
        }
        return isValid;
    }
}

