/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import java.text.DateFormat;
import java.util.Date;

public class DateInRangeValidationListener
implements ParameterListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/DateInRangeValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final Date m_lowerBound;
    private final Date m_upperBound;
    private final String m_baseErrorMsg;

    public DateInRangeValidationListener(Date lower, Date upper) {
        if (lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("Lower bound must be earlier than or equal to upper bound.");
        }
        this.m_lowerBound = lower;
        this.m_upperBound = upper;
        DateFormat formatter = DateFormat.getDateInstance();
        StringBuffer msg = new StringBuffer(128);
        msg.append("The following dates are out of the specified range of (").append(formatter.format(this.m_lowerBound)).append(",").append(formatter.format(this.m_upperBound)).append(") :");
        this.m_baseErrorMsg = msg.toString();
    }

    public void validate(ParameterEvent e) {
        DateFormat formatter = DateFormat.getDateInstance();
        ParameterData data = e.getParameterData();
        Object obj = data.getValue();
        if (obj == null) {
            return;
        }
        boolean isValid = true;
        StringBuffer msg = null;
        if (data.getValue() instanceof Object[]) {
            Date[] values = (Date[])obj;
            for (int i = 0; i < values.length; ++i) {
                Date value = values[i];
                if (!this.isOutOfRange(value)) continue;
                if (msg == null) {
                    msg = this.makeErrorBuffer();
                }
                msg.append(" ").append(formatter.format(value));
                isValid = false;
            }
        } else {
            Date value = (Date)obj;
            if (this.isOutOfRange(value)) {
                msg = this.makeErrorBuffer();
                msg.append(" ").append(formatter.format(value));
                isValid = false;
            }
        }
        if (!isValid) {
            data.addError(msg.toString());
        }
    }

    private boolean isOutOfRange(Date value) {
        return this.m_lowerBound.compareTo(value) >= 0 || value.compareTo(this.m_upperBound) >= 0;
    }

    private StringBuffer makeErrorBuffer() {
        return new StringBuffer(this.m_baseErrorMsg);
    }
}

