/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class Date
extends Widget
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Date.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected OptionGroup m_year;
    protected OptionGroup m_month;
    protected TextField m_day;

    public Date(ParameterModel model) {
        super(model);
        if (!(model instanceof DateParameter)) {
            throw new IllegalArgumentException("The Date widget " + model.getName() + " must be backed by a DateParameter parmeter model");
        }
        String name = model.getName();
        String nameYear = name + ".year";
        String nameMonth = name + ".month";
        String nameDay = name + ".day";
        DateFormatSymbols dfs = null;
        Locale locale = Kernel.getContext().getLocale();
        dfs = locale != null ? new DateFormatSymbols(locale) : new DateFormatSymbols();
        Calendar currentTime = GregorianCalendar.getInstance();
        this.m_year = new YearFragment(nameYear, this);
        this.m_month = new MonthFragment(nameMonth, this);
        this.m_day = new DayFragment(nameDay, this);
        this.m_day.setMaxLength(2);
        this.m_day.setSize(2);
        String[] months = dfs.getMonths();
        for (int i = 0; i < months.length; ++i) {
            if (months[i].length() <= 0) continue;
            this.m_month.addOption(new Option(String.valueOf(i), months[i]));
        }
        int currentYear = currentTime.get(1);
        this.setYearRange(currentYear - 1, currentYear + 3);
    }

    public Date(String name) {
        this(new DateParameter(name));
    }

    public void setYearRange(int startYear, int endYear) {
        Assert.assertNotLocked(this);
        this.m_year.clearOptions();
        for (int j = startYear; j <= endYear; ++j) {
            this.m_year.addOption(new Option(String.valueOf(j)));
        }
    }

    public String getType() {
        return "date";
    }

    public void setMaxLength(int length) {
        this.setAttribute("MAXLENGTH", String.valueOf(length));
    }

    public boolean isCompound() {
        return true;
    }

    protected String getElementTag() {
        return "bebop:date";
    }

    public void generateWidget(PageState ps, Element parent) {
        if (!this.isVisible(ps)) {
            return;
        }
        Element date = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        date.addAttribute("name", this.getParameterModel().getName());
        this.exportAttributes(date);
        this.m_month.generateXML(ps, date);
        this.m_day.generateXML(ps, date);
        this.m_year.generateXML(ps, date);
    }

    public void setDisabled() {
        this.m_month.setDisabled();
        this.m_day.setDisabled();
        this.m_year.setDisabled();
    }

    public void setReadOnly() {
        this.m_month.setReadOnly();
        this.m_day.setReadOnly();
        this.m_year.setReadOnly();
    }

    public void setForm(Form f) {
        super.setForm(f);
        this.m_year.setForm(f);
        this.m_month.setForm(f);
        this.m_day.setForm(f);
    }

    public Object getFragmentValue(PageState ps, int field) {
        java.util.Date value;
        Assert.assertNotNull(ps, "PageState");
        FormData f = this.getForm().getFormData(ps);
        if (f != null && (value = (java.util.Date)f.get(this.getName())) != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(value);
            return new Integer(c.get(field));
        }
        return null;
    }

    public void setClassAttr(String at) {
        this.m_month.setClassAttr(at);
        this.m_year.setClassAttr(at);
        this.m_day.setClassAttr(at);
        super.setClassAttr(at);
    }

    protected class DayFragment
    extends TextField {
        protected Date parent;

        public DayFragment(String name, Date parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 5);
        }
    }

    protected class MonthFragment
    extends SingleSelect {
        protected Date parent;

        public MonthFragment(String name, Date parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            return this.parent.getFragmentValue(ps, 2);
        }
    }

    protected class YearFragment
    extends SingleSelect {
        protected Date parent;

        public YearFragment(String name, Date parent) {
            super(name);
            this.parent = parent;
        }

        protected ParameterData getParameterData(PageState ps) {
            Object value = this.getValue(ps);
            if (value == null) {
                return null;
            }
            return new ParameterData(this.getParameterModel(), value);
        }

        public Object getValue(PageState ps) {
            Object value = this.parent.getFragmentValue(ps, 1);
            if (value == null) {
                Calendar currentTime = GregorianCalendar.getInstance();
                int currentYear = currentTime.get(1);
                value = new Integer(currentYear);
            }
            return value;
        }
    }
}

