/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.TextStylable;
import com.arsdigita.bebop.util.Color;
import com.arsdigita.bebop.util.Size;

public abstract class BlockStylable
extends TextStylable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/BlockStylable.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public static final int FULL_WIDTH = 64;
    public static final int INSERT = 128;
    public static final int ABSMIDDLE = 256;
    public static final int ABSBOTTOM = 512;
    public static final int TEXTTOP = 1024;
    public static final int BASELINE = 2048;

    private String getSideStub(int sideEnum) {
        switch (sideEnum) {
            case 8: {
                return "top";
            }
            case 32: {
                return "bottom";
            }
            case 1: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        return "";
    }

    public void setPadding(Size size) {
        this.setPadding(size, 8);
        this.setPadding(size, 32);
        this.setPadding(size, 1);
        this.setPadding(size, 4);
    }

    public void setPadding(Size size, int sideEnum) {
        this.setAttribute(this.getSideStub(sideEnum) + "Padding", size.toString());
    }

    public void setBorder(Size size) {
        this.setBorder(size, 8);
        this.setBorder(size, 32);
        this.setBorder(size, 1);
        this.setBorder(size, 4);
    }

    public void setBorder(Size size, int sideEnum) {
        this.setAttribute(this.getSideStub(sideEnum) + "Border", size.toString());
    }

    public void setBorderColor(Color borderColor) {
        this.setAttribute("borderColor", borderColor.toString());
    }

    public void setMargin(Size size) {
        this.setMargin(size, 8);
        this.setMargin(size, 32);
        this.setMargin(size, 1);
        this.setMargin(size, 4);
    }

    public void setMargin(Size size, int sideEnum) {
        this.setAttribute(this.getSideStub(sideEnum) + "Margin", size.toString());
    }

    public void setHorizontalAlignment(int alignmentEnum) {
        String alignmentLiteral = "";
        switch (alignmentEnum) {
            case 1: {
                alignmentLiteral = "left";
                break;
            }
            case 4: {
                alignmentLiteral = "right";
                break;
            }
            case 2: {
                alignmentLiteral = "center";
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined Arg in setHorizontalAlignment");
            }
        }
        this.setAttribute("horizontalAlignment", alignmentLiteral);
    }

    public void setVerticalAlignment(int alignmentEnum) {
        String alignmentLiteral = "";
        switch (alignmentEnum) {
            case 8: {
                alignmentLiteral = "top";
                break;
            }
            case 32: {
                alignmentLiteral = "bottom";
                break;
            }
            case 2: {
                alignmentLiteral = "center";
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined Arg in setVerticalAlignment");
            }
        }
        this.setAttribute("verticalAlignment", alignmentLiteral);
    }
}

