/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ConfirmPage;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.TextStylable;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.util.TooManyListenersException;

public abstract class BaseLink
extends TextStylable
implements Cloneable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/BaseLink.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final String TYPE_ATTR = "type";
    private final String HREF_NO_JAVASCRIPT = "href_no_javascript";
    private final String HREF = "href";
    protected String m_url;
    protected String m_noJavascriptURL = null;
    protected Component m_child;
    private PrintListener m_printListener;
    private String m_sConfirmMsg = "";

    public BaseLink(Component child, String url) {
        this.m_url = url;
        this.m_child = child;
    }

    public BaseLink(String label, String url) {
        this((Component)new Label(label), url);
    }

    public BaseLink(Component child, PrintListener l) {
        this(child, "");
        try {
            this.addPrintListener(l);
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("Too many listeners: " + e.getMessage(), e);
        }
    }

    public BaseLink(String label, PrintListener l) {
        this((Component)new Label(label), l);
    }

    public BaseLink(PrintListener l) {
        this("", l);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseLink result = (BaseLink)super.clone();
        result.m_printListener = null;
        return result;
    }

    public void addPrintListener(PrintListener listener) throws IllegalStateException, TooManyListenersException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument listener can not be null");
        }
        if (this.m_printListener != null) {
            throw new TooManyListenersException("Too many listeners. Can only have one");
        }
        this.m_printListener = listener;
    }

    public void removePrintListener(PrintListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        if (listener != this.m_printListener) {
            throw new IllegalArgumentException("listener is not registered with this widget");
        }
        this.m_printListener = null;
    }

    protected BaseLink firePrintEvent(PageState state) {
        BaseLink l = this;
        if (this.m_printListener != null) {
            try {
                l = (BaseLink)this.clone();
                this.m_printListener.prepare(new PrintEvent(this, state, l));
            }
            catch (CloneNotSupportedException e) {
                l = this;
                throw new UncheckedWrapperException(e);
            }
        }
        return l;
    }

    public final Component getChild() {
        return this.m_child;
    }

    public void setChild(Component child) {
        Assert.assertNotLocked(this);
        this.m_child = child;
    }

    public final String getTarget() {
        return this.m_url;
    }

    public final void setTarget(String url) {
        Assert.assertNotLocked(this);
        this.m_url = url;
    }

    protected void setTypeAttr(String t) {
        Assert.assertNotLocked(this);
        this.setAttribute("type", t);
    }

    protected abstract void generateURL(PageState var1, Element var2);

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            BaseLink target = this.firePrintEvent(state);
            Element link = parent.newChildElement("bebop:link", "http://www.arsdigita.com/bebop/1.0");
            target.generateURL(state, link);
            target.exportAttributes(link);
            target.setupNoJavascriptURL(state, link);
            target.exportAttributes(link);
            target.generateExtraXMLAttributes(state, link);
            target.getChild().generateXML(state, link);
        }
    }

    private String getAbsoluteUrl(PageState ps, String sUrl) {
        String sReturn = "";
        if (sUrl.indexOf(":") != -1 || sUrl.indexOf("/") == 0) {
            sReturn = sUrl;
        } else {
            String sThisURL = "";
            try {
                sThisURL = ps.stateAsURL();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            int iIndex = sThisURL.lastIndexOf("/");
            sReturn = iIndex == -1 ? "/" + sUrl : sThisURL.substring(0, iIndex) + "/" + sUrl;
        }
        return sReturn;
    }

    protected void setupNoJavascriptURL(PageState ps, Element link) {
        String sURL = null;
        if (this.m_sConfirmMsg.length() > 0) {
            String sOkUrl = this.getAbsoluteUrl(ps, link.getAttribute("href"));
            String sCancelUrl = null;
            try {
                sCancelUrl = ps.stateAsURL();
            }
            catch (IOException e) {
                Assert.fail("Could not get current page state as URL");
            }
            sURL = ConfirmPage.getConfirmUrl(this.m_sConfirmMsg, sOkUrl, sCancelUrl);
        } else {
            sURL = this.m_noJavascriptURL == null ? link.getAttribute("href") : this.m_noJavascriptURL;
        }
        link.addAttribute("href_no_javascript", sURL);
        this.exportAttributes(link);
    }

    protected void generateExtraXMLAttributes(PageState state, Element link) {
    }

    public void setOnClick(String value) {
        if (value != null) {
            Assert.assertTrue(!value.toLowerCase().startsWith("return confirm("), "Do not use setOnClick() to set confirmation messages. Use setCofirmation() instead.");
        }
        this.setAttribute("onclick", value);
    }

    public void setConfirmation(String message) {
        if (Assert.isAssertEnabled()) {
            boolean isGoodMessage = message.indexOf("'") == -1 && message.indexOf("\\") == -1;
            Assert.assertTrue(isGoodMessage, "confirmation message cannot contain apostrophe or back slash");
        }
        this.setAttribute("confirm", "confirm");
        this.setAttribute("onclick", "return confirm(\\'" + message + "\\');");
        this.m_sConfirmMsg = message;
    }

    public final void setNoJavascriptTarget(String sURL) {
        Assert.assertNotLocked(this);
        this.m_noJavascriptURL = sURL;
    }

    public final String getNoJavascriptTarget() {
        return this.m_noJavascriptURL;
    }
}

