/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import org.jdom.Namespace;
import com.arsdigita.kernel.*;
import com.arsdigita.util.UncheckedWrapperException;

public abstract class PermissionsAction extends TestAction {
    public PermissionsAction(String name) {
        super(name);
    }

    public PermissionsAction(String name, Namespace ns) {
        super(name, ns);
    }

    public Party getUser() {
        String email = getAttributeValue("user");

        if ("swa@redhat.com".equals(email)) {
            return Kernel.getSystemParty();
        }

        PartyCollection coll = Party.retrieveAllParties();
        coll.addEqualsFilter("primaryEmail", email);
        if (coll.next()) {
            Party user = coll.getParty();
            return user;
        } else {
            throw new RuntimeException("No such user: " + email);
        }
    }

    public void execute() throws Exception {

        KernelExcursion ex = new KernelExcursion() {
            protected void excurse() {
                setEffectiveParty(getUser());
                try {
                    doPermissionTest();
                } catch(Exception e) {
                    throw new UncheckedWrapperException("Permissions Action failure", e);
                }

            }
        };

        ex.run();
    }

    public abstract void doPermissionTest() throws Exception;
}
