/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import junit.framework.TestCase;

import java.util.HashMap;
import java.util.Map;

import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;
import com.arsdigita.util.StringUtils;

/**
 * Created by IntelliJ IDEA.
 * User: jorris
 * Date: Nov 26, 2003
 * Time: 8:47:20 AM
 * To change this template use Options | File Templates.
 */
public class URLTest extends WebTestCase {

    public URLTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        HttpServletDummyRequest request = m_container.getRequest();
        HttpServletDummyResponse response = m_container.getResponse();
        Web.init(request, m_config.getServletContext(),
                 new UserContext(request, response));
    }

    public void testConstruction() {
        // verifies fix for bug 110058
        HttpServletDummyRequest request = m_container.getRequest();
        request.setAttribute("com.arsdigita.dispatcher.DispatcherPrefix", "/plaintext");
        URL test = new URL("http",
                "localhost",
                9000,
                "/apps",
                "/ccm",
                "/portal/homepage.jsp",
                null );

        final String linkUrl = "/apps/plaintext/ccm/portal/homepage.jsp";
        assertEquals(linkUrl, test.toString());
        final String fullUrl = "http://localhost:9000" + linkUrl;
        assertEquals(fullUrl, test.getURL());
    }

    public void testGetMethods() {
        URL test = new URL("http",
                "localhost",
                9000,
                "/apps",
                "/ccm",
                "/portal/homepage.jsp",
                null );
        // No dispatcher prefix, will fail (bug 111040)
        assertTrue(StringUtils.emptyString(test.getDispatcherPrefix()));
    }
}
