/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.tools.junit.framework.BaseTestCase;


public class HostTest extends BaseTestCase {

    public static final String TEST_HOST1 = "test-app01.example.com";
    public static final String TEST_HOST2 = "test-app02.example.com";

    public HostTest(String name) {
        super(name);
    }

    public void testHosts() throws Exception {
        // Create a pair of hosts to test with
        Host host1 = Host.create(TEST_HOST1, 80);
        Host host2 = Host.create(TEST_HOST2, 8080);

        WebConfigExposer.setHosts(new Host[] { host1, host2 });
        WebConfigExposer.setCurrentHost(host1);

        // toString() should not include the port if it is 80
        assertEquals(TEST_HOST1, host1.toString());
        assertEquals(TEST_HOST2 + ":8080", host2.toString());
    }
}
