/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import com.arsdigita.util.Assert;

import junit.framework.Test;

/**
 * Versioning test suite.
 *
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2003-02-20
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 **/
public class XVersioningSuite extends PackageTestSuite {
    public XVersioningSuite() {
        super();
    }

    public XVersioningSuite(Class klass) {
        super(klass);
    }

    public XVersioningSuite(String name) {
        super(name);
    }

    public static Test suite() {
        XVersioningSuite suite = new XVersioningSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new CoreTestSetup(suite);
        wrapper.setSetupSQLScript(getSQLScript("setup.sql"));
        wrapper.setTeardownSQLScript(getSQLScript("teardown.sql"));
        return wrapper;
    }

    public static void main(String[] args) throws Exception {
        junit.textui.TestRunner.run( suite() );
    }

    private static String getSQLScript(String scriptName) {
        return "/com/arsdigita/versioning/" + scriptName;
    }
}
