/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import java.util.Iterator;
import java.util.NoSuchElementException;

import junit.framework.TestCase;

public class QueueMapTest extends TestCase {
    private final static String S1 = "s1";
    private final static String S2 = "s2";
    private final static String S3 = "s3";
    private final static String S4 = "s4";

    public QueueMapTest(String name) {
        super(name);
    }

    public void testQueueMap() {
        QueueMap qm = new QueueMap();
        assertTrue("queue map is empty", !qm.hasNext());
        qm.enqueue(S1, S1);
        assertTrue("queue map is not empty", qm.hasNext());
        qm.enqueue(S2, S2);
        assertEquals("S1 dequeued", S1, (String) qm.dequeue());
        boolean hasBeenRaised = false;
        try {
            qm.enqueue(S1, "whatever");
        } catch (QueueMap.AlreadyEnqueuedException ex) {
            hasBeenRaised = true;
        }
        assertTrue("exception has been properly raised",
                   hasBeenRaised);
        qm.enqueue(S3, S3);
        assertEquals("S2 dequeued", S2, (String) qm.dequeue());
        assertEquals("S3 dequeed", S3, (String) qm.dequeue());
        assertTrue("queue map is empty", !qm.hasNext());

        hasBeenRaised = false;
        try {
            qm.dequeue();
        } catch (NoSuchElementException ex) {
            hasBeenRaised = true;
        }
        assertTrue("NoSuchElementException has been properly raised",
                   hasBeenRaised);
        assertTrue("contains S1", qm.contains(S1));
        assertTrue("contains S2", qm.contains(S2));
        assertTrue("contains S3", qm.contains(S3));
    }

    public void testRewind() {
        QueueMap qm = new QueueMap();
        qm.enqueue(S1, S1);
        qm.enqueue(S2, S2);
        qm.enqueue(S3, S3);
        qm.dequeue();
        qm.dequeue();
        qm.dequeue();
        qm.rewind();
        assertEquals("S1 dequeued", S1, (String) qm.dequeue());
        qm.dequeue();
        qm.rewind();
        qm.dequeue();
        assertEquals("S2 dequeued", S2, (String) qm.dequeue());
    }
}
