/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

public interface Const {
    String MARKED      = " is marked versioned";
    String UNMARKED    = " is not marked versioned";
    String UNVERSIONED = " is marked unversioned";
    String VERSIONED_TYPE      = " is a versioned type";
    String COVERSIONED_TYPE    = " is a coversioned type";
    String RECOVERABLE         = " is recoverable";
    String UNREACHABLE         = " is unreachable";


    String EVENT_PROC_MODEL = "versioning.events";
    // object types
    String C1    = EVENT_PROC_MODEL + ".C1";
    String C2    = EVENT_PROC_MODEL + ".C2";
    String RET1  = EVENT_PROC_MODEL + ".RET1";
    String RT1   = EVENT_PROC_MODEL + ".RT1";
    String UT1   = EVENT_PROC_MODEL + ".UT1";
    String UT2   = EVENT_PROC_MODEL + ".UT2";
    String UVCT1 = EVENT_PROC_MODEL + ".UVCT1";
    String UVCT2 = EVENT_PROC_MODEL + ".UVCT2";
    String VT1   = EVENT_PROC_MODEL + ".VT1";
    String VT1E  = EVENT_PROC_MODEL + ".VT1E";
    String VT2   = EVENT_PROC_MODEL + ".VT2";
    String VT3   = EVENT_PROC_MODEL + ".VT3";
    String VT4   = EVENT_PROC_MODEL + ".VT4";
    String VT5   = EVENT_PROC_MODEL + ".VT5";
    String VUT1  = EVENT_PROC_MODEL + ".VUT1";

    // attribute names
    String C1S        = "c1s";
    String C2_ATTR    = "c2";
    String CONTENT    = "content";
    String ID         = "id";
    String INT_ATTR   = "intAttr";
    String NAME       = "name";
    String RET1S      = "ret1s";
    String RT1_ATTR   = "rt1";
    String UNVER_ATTR = "unverAttr";
    String UVCT1S     = "uvct1s";
    String UVCT2S     = "uvct2s";
    String UT2S       = "ut2s";
    String VT1E_ATTR  = "vt1eAttr";
    String VUT1_ATTR  = "vut1Attr";
}
