--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //core-platform/dev/test/src/com/arsdigita/test/ddl/canonical/oracle-se/table-acs_permissions-auto.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $
create table acs_permissions (
    privilege VARCHAR(100) not null,
        -- referential constraint for privilege deferred due to circular dependencies
    object_id INTEGER not null,
        -- referential constraint for object_id deferred due to circular dependencies
    grantee_id INTEGER not null,
        -- referential constraint for grantee_id deferred due to circular dependencies
    creation_date DATE not null,
    creation_ip VARCHAR(50),
    creation_user INTEGER,
        -- referential constraint for creation_user deferred due to circular dependencies
    constraint acs_per_gra_id_obj_id__p_lrweb
      primary key(grantee_id, object_id, privilege)
);
