/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.test;

import com.meterware.httpunit.WebResponse;

import java.io.IOException;

/**
 * Class NoSuchLinkException
 * 
 * @author jorris@redhat.com
 * @version $Revision $1 $ $Date: 2004/04/07 $
 */
public class NoSuchLinkException extends HttpUnitException {

    public NoSuchLinkException(final String linkText, final WebResponse resp) {
        super("No link named " +
                linkText +
                System.getProperty("line.separator") +
                getPageHTML(resp));
    }

    private static String getPageHTML(final WebResponse resp) {
        String text;
        try {
            text = resp.getText();
        } catch (IOException e) {
            text = "ERROR: Could not get HTML from WebResponse";
        }
        return text;
    }

}
