/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.test;

import com.arsdigita.web.URL;
import com.meterware.httpunit.*;

import java.io.IOException;
import java.net.MalformedURLException;

import java.io.*;
import java.util.*;

import junit.framework.*;

/**
 *
 * Provide a wrapper for common use functionalities in HttpUnit.
 *
 * @author (<a href="mailto:ddao@arsdigita.com">David Dao</a>)
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/test/HttpUnitTestCase.java#7 $ $DateTime: 2004/04/07 16:07:11 $
 * @since
 *
 */

public abstract class HttpUnitTestCase extends TestCase {

    protected WebConversation browser = new WebConversation();
    protected String baseUrl = null;

    public HttpUnitTestCase(String name) {
        super(name);

        // Get base url from test.server.url system properties.
        baseUrl = System.getProperty("test.server.url");

    }
    protected WebForm getForm(String url, int index) throws Exception {
        WebResponse response = getResponse(url);

        return response.getForms()[index];

    }

    protected WebForm getForm(WebRequest req, int index) throws Exception {
        WebResponse response = browser.getResponse(req);

        return response.getForms()[index];
    }

    protected WebForm getForm(WebLink link, int index) throws Exception {
        WebRequest request = link.getRequest();

        return getForm(request, index);
    }

    protected WebForm getFormWithName(String url, String name) throws Exception {
        WebResponse response = getResponse(url);

        return response.getFormWithName(name);

    }

    protected WebForm getFormWithName(WebRequest req, String name) throws Exception {
        WebResponse response = browser.getResponse(req);

        return response.getFormWithName(name);
    }

    protected WebForm getFormWithName(WebLink link, String name) throws Exception {
        WebRequest request = link.getRequest();

        return getFormWithName(request,name);
    }

    protected WebTable getTable(String url, int index) throws Exception {
        WebResponse response = getResponse(url);

        return response.getTables()[index];
    }

    protected WebResponse submit(WebRequest request) throws Exception {
        return browser.getResponse(request);
    }

    protected WebResponse getResponse(WebRequest request) throws Exception {
        return browser.getResponse(request);
    }

    protected WebResponse getResponse(String url) throws Exception {
        return browser.getResponse(baseUrl + URL.getDispatcherPath() + url);
    }

    protected WebResponse getResponse(WebLink link) throws Exception {
        return browser.getResponse(link.getRequest());
    }
}
