/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;


/**
 * SearchTestBookH class.  Used to test generating XML documents
 * for related objects.
 *
 * @author Jeff Teeters
 **/
public class SearchTestBookH extends SearchableACSObject {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/intermedia/SearchTestBookH.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Chapters associated with this book
    DataAssociation m_chapters = null;

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.intermedia.SearchTestBookH";

    public SearchTestBookH() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SearchTestBookH(String typeName) {
        super(typeName);
    }

    public SearchTestBookH(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SearchTestBookH(int key)  throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public SearchTestBookH(DataObject dataObject) {
        super(dataObject);
    }


    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getDisplayName() {
        return "SearchTestBookH-DisplayName";
    }

    /* Register instantiator with DomainObjectFactory, must be called by
       initializer */
    public static void setupDomainObjectFactory() {
        DomainObjectInstantiator instantiator;

        instantiator = new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new SearchTestBookH(dataObject);
                }
            };
        DomainObjectFactory.registerInstantiator(
                                                 SearchTestBookH.BASE_DATA_OBJECT_TYPE,
                                                 instantiator);
    }



    public void addChapter(SearchTestChapterH chapter) {
        if (m_chapters == null) {
            m_chapters = (DataAssociation) get("chapters");
        }
        chapter.addToAssociation(m_chapters);
    }

    public void removeChapter(SearchTestChapterH chapter) {
        if (m_chapters == null) {
            m_chapters = (DataAssociation) get("chapters");
        }
        chapter.removeFromAssociation(m_chapters);
    }


    public String getTitle() {
        return (String) get("title");
    }

    public void setTitle(String title) {
        set("title", title);
    }

    // Methods needed to implment Searchable interface
    public String getSearchSummary()  { return ""; };
    public String getSearchLinkText() { return ""; };
    public String getSearchUrlStub()  { return ""; };
    public String getSearchXMLContent() {
        return "use_SearchIndexHelp";
    }
    public byte[] getSearchRawContent() {
        return "use_SearchIndexHelp".getBytes();
    }
}
