/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import org.apache.log4j.Logger;


public class ObserverTest extends BaseTestCase {

    private static Logger s_log =
            Logger.getLogger(ObserverTest.class);

    public ObserverTest(String name) {
        super(name);
    }

    public void testObservers() throws Throwable {
        TestSearchIndex.reset();
        
        Search.getConfig().setIndexerType(SearchSuite.TEST_INDEXER);
        Search.getConfig().setLazyUpdates(false);

        Note note1 = Note.create(
            "Note Number 1",
            "You can fool some of the people some of the time," +
            "and some of the people all of the time," +
            "and that is sufficient.");
        note1.save();

        // If no adapter is available, it shouldn't end up in
        // the index
        assertTrue(!TestSearchIndex.containsDocument(note1));
        
        // Add the note adapter
        MetadataProviderRegistry.registerAdapter(Note.BASE_DATA_OBJECT_TYPE,
                                                 new NoteAdapter());
        
        Note note2 = Note.create(
            "Note Number 2",
            "We took four laboratory mice, and for six days exposed " +
            "them to Mozart's 'Clarinet Quintet'.  After the six days " +
            "was over, we then placed an actual clarinet inside the " +
            "cage with the mice, to see if the mice had grasped the " +
            "subtle nuances of classical music.  The results... were " +
            "disappointing.  Next time, we will feed and water the mice."+
            "Now, Dave with a sideways look at deoxyribonucleic acid.  Dave");
        note2.save();
        assertTrue(TestSearchIndex.containsDocument(note2));
        
        // Check it disappears when deleted
        note2.delete();
        assertTrue(!TestSearchIndex.containsDocument(note2));

        MetadataProviderRegistry.unregisterAdapter(Note.BASE_DATA_OBJECT_TYPE);
    }
}
