/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.domain.DomainObject; 
import com.arsdigita.kernel.Party;
import java.util.Date;
import java.util.Locale;


public class NoteAdapter implements MetadataProvider {


    public String getTypeSpecificInfo(DomainObject dobj) {
        Note note = (Note)dobj;
        return null;
    }
    public Locale getLocale(DomainObject dobj) {
        Note note = (Note)dobj;
        return Locale.ENGLISH;
    }
    public String getTitle(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getTitle();
    }
    public String getSummary(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getText().substring(0, 50);
    }
    public Date getCreationDate(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getCreationDate();
    }
    public Party getCreationParty(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getCreationUser();
    }
    public Date getLastModifiedDate(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getLastModifiedDate();
    }
    public Party getLastModifiedParty(DomainObject dobj) {
        Note note = (Note)dobj;
        return note.getLastModifiedUser();
    }
    public ContentProvider[] getContent(DomainObject dobj,
                                        ContentType type) {
        Note note = (Note)dobj;
        if (type == ContentType.TEXT) {
            return new ContentProvider[] {
                new StringContent(note.getText())
            };
        } else {
            return new ContentProvider[] {};
        }
    }
    
    
    private class StringContent implements ContentProvider {
        
        private String m_text;

        public StringContent(String text) {
            m_text = text;
        }

        public String getContext() {
            return null;
        }

        public ContentType getType() {
            return ContentType.TEXT;
        }
        
        public byte[] getBytes() {
            return m_text.getBytes();
        }
    }
}
