/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import org.apache.log4j.Logger;


public class ConfigTest extends BaseTestCase {

    private static Logger s_log =
            Logger.getLogger(ConfigTest.class);

    public ConfigTest(String name) {
        super(name);
    }

    public void testConfig() throws Throwable {
        SearchConfig config = Search.getConfig();
        
        config.setIndexerType(SearchSuite.TEST_INDEXER);

        assertTrue(config.getIndexerType().equals(SearchSuite.TEST_INDEXER));
        assertTrue(config.getObserver().equals(SearchSuite.TEST_INDEXER.getObserver()));
        
        assertTrue(!config.isIntermediaEnabled());
        assertTrue(!config.isLuceneEnabled());

        assertTrue(!config.allowsRawContent());
        assertTrue(!config.allowsXMLContent());
        assertTrue(config.allowsTextContent());


        
        config.setIndexerType(IndexerType.INTERMEDIA);
        assertTrue(config.isIntermediaEnabled());
        assertTrue(!config.isLuceneEnabled());

        assertTrue(config.allowsRawContent());
        assertTrue(config.allowsXMLContent());
        assertTrue(!config.allowsTextContent());



        config.setIndexerType(IndexerType.LUCENE);
        assertTrue(!config.isIntermediaEnabled());
        assertTrue(config.isLuceneEnabled());

        assertTrue(!config.allowsRawContent());
        assertTrue(!config.allowsXMLContent());
        assertTrue(config.allowsTextContent());

    }
}
