/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.notification;

// ACS Core
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;

// JUnit classes
import com.arsdigita.tools.junit.framework.BaseTestCase;

// ACS mail
import com.arsdigita.mail.*;


/**
 * Test of DigestQueueManager, similar to SimpleQueueManagerTest.
 *
 * @author Stefan Deusch
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/notification/DigestQueueManagerTest.java#7 $
 */
public class DigestQueueManagerTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/notification/DigestQueueManagerTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    static ManagerDispatcher requestMgr;
    static ManagerDispatcher digestQMgr;

    /**
     * Timeout for email processing
     */

    final static int MAX_WAIT = 25;

    public DigestQueueManagerTest (String name) {
        super(name);
    }

    protected void setUp() {
        SimpleServer.startup();

        requestMgr = new ManagerDispatcher(new RequestManager());
        digestQMgr = new ManagerDispatcher(new DigestQueueManager());
    }

    protected void tearDown() {
        requestMgr.interrupt();
        digestQMgr.interrupt();
    }


    /**
     * test if DigestQueueManager sends mails correctly,
     * Watch mail arriving on SimpleServer on localhost
     * 5 mails with one message each should be sent to
     * 5 recipients.
     */
    public void testDigestQueueManager001() {
        Session session = SessionManager.getSession();

        // create a Digest with 5 notifications to 5 users

        int count = 5;
        Digest d1 = NotificationSuite.getDigest(count);

        // transaction context is resurrected in getDigest above

        SimpleServer.reset();

        NotificationSuite.runManager(requestMgr);
        NotificationSuite.runManager(digestQMgr);
        NotificationSuite.runManager(requestMgr);

        if (!NotificationSuite.assertReceive(count,MAX_WAIT))
            fail("did not receive " + count + " emails in " + MAX_WAIT + " seconds");
        else
            System.out.println("testDigestQueueManager001 passed");

    }

    /**
     * test if DigestQueueManager sends mails correctly,
     * Watch mail arriving on SimpleServer on localhost and count.
     * 1 Mail containing 5 messages to 1 User should be received.
     *
     */
    public void testDigestQueueManager002() {
        Session session = SessionManager.getSession();

        SimpleServer.reset();

        // create a Digest with 5 notifications to one user
        int count = 5;
        User   to = NotificationSuite.getUser();
        Digest d1 = NotificationSuite.getDigest(count,to.getOID());

        // transaction context is resurrected in getDigest above

        NotificationSuite.runManager(requestMgr);
        NotificationSuite.runManager(digestQMgr);
        NotificationSuite.runManager(requestMgr);

        if (!NotificationSuite.assertReceive(1,MAX_WAIT))
            fail("did not receive 1 email in " + MAX_WAIT + " seconds");
        else
            System.out.println("testDigestQueueManager002 passed");
    }


    /**
     * Main method required to make this test runnable.
     */

    public static void main (String args[]) {
        junit.textui.TestRunner.run(DigestQueueManagerTest.class);
    }
}
