/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.messaging;

// JUnit classes
import com.arsdigita.tools.junit.framework.BaseTestCase;

/**
 * Test cases for sort keys.
 *
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/messaging/SortKeyTest.java#7 $
 */

public class SortKeyTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/messaging/SortKeyTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public SortKeyTest (String name) {
        super(name);
    }

    /**
     * Verify that you cannot create invalid sort keys.
     */

    public void testSortKey001() {

        try {
            SortKey s = new SortKey("###");
            fail("created nonalpha sortkey");
        } catch (IllegalArgumentException e) {
            // ignore
        }

        try {
            SortKey s = new SortKey("0000");
            fail("created 4-digit sortkey");
        } catch (IllegalArgumentException e) {
            // ignore
        }
    }

    /**
     * Verify generating serveral generations of sort keys.  Loops up
     * and then back and verifies recovery of the parent key.
     */

    public void testSortKey002() {

        String root = "0a5";

        SortKey key = new SortKey(root);

        for (int i = 0; i < 10; i++) {
            if (i % 3 == 0) {
                key = key.getChild();
            } else {
                key.next();
            }
        }

        for (int i = 0; i < 4; i++) {
            key = key.getParent();
        }

        assertEquals("Failed to recover root key",
                     root,
                     key.toString());
    }

    /**
     * Verify that depth calculation is correct.
     */

    public void testSortKey003() {

        SortKey key = new SortKey();

        for (int i = 0; i < 10; i++)
            key = key.getChild();

        assertEquals("Failed to compute depth",
                     11,
                     key.getDepth());
    }

    /**
     * Verify that incrementing a key works
     */

    public void testSortKey004() {

        SortKey key = new SortKey();

        for (int i = 0; i < 1000; i++) {
            key.next();
        }

        assertEquals("sort key incremented wrong",
                     "0G8",
                     key.toString());
    }
}
