/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.messaging;

/**
 * Test cases for HTML messages.
 *
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/messaging/HtmlMessageTest.java#7 $
 */

public class HtmlMessageTest extends MessageTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/messaging/HtmlMessageTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static String subject = "This is the subject";
    private static String body    = "<p>This is the <b>body</b></p>";
    private static String type    = MessageType.TEXT_HTML;

    public HtmlMessageTest(String name) {
        super(name);
    }

    /**
     * Create a simple message using the various set methods.
     */


    public void testMessageCreate001() {
        try {
            Message msg = new Message();

            msg.setFrom(from);
            msg.setSubject(subject);
            msg.setBody(body,type);

            assertEquals(subject,msg.getSubject());
            assertEquals(body,msg.getBody());
            assertEquals(type,msg.getBodyType());

        } catch (Exception e) {
            fail(e.getMessage());
        }
    }

    /**
     * Create a simple message using the default constructor.
     */

    public void testMessageCreate002() {
        try {
            Message msg = new Message(from,subject);
            msg.setBody(body,type);

            assertEquals(subject,msg.getSubject());
            assertEquals(body,msg.getBody());
            assertEquals(type,msg.getBodyType());

        } catch (Exception e) {
            fail(e.getMessage());
        }
    }

    /**
     * Create a simple message and save it to the database.
     */

    public void testCreateMessage003() {
        try {
            Message msg = new Message(from,subject);
            msg.setBody(body,type);
            msg.save();

            // Retrieve a copy of the message and verify its contents

            Message msg2 = new Message(msg.getOID());

            assertEquals(msg.getSubject(),  msg2.getSubject());
            assertEquals(msg.getBody(),     msg2.getBody());
            assertEquals(msg.getBodyType(), msg2.getBodyType());

            // Delete the original message

            msg.delete();

        } catch (Exception e) {
            fail(e.getMessage());
        }
    }

    /**
     * Main method required to make this test runnable.
     */

    public static void main (String args[]) {
        junit.textui.TestRunner.run(HtmlMessageTest.class);
    }

}
