/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import org.apache.log4j.Logger;

/**
 * Sample listener for use in test case.
 *
 * @version 1.0
 */

public class SampleListener implements PackageEventListener {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/SampleListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public final static String versionID = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/SampleListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_cat =
        Logger.getLogger(SampleListener.class.getName());

    public void onMount(SiteNode siteNode, PackageInstance pkg) {
        s_cat.debug("onMount");
    }

    public void onUnmount(SiteNode siteNode, PackageInstance pkg) {
        s_cat.debug("onUnmount");
    }

    public void onCreate(PackageInstance pkg) {
        s_cat.debug("onCreate");
    }

    public void onDelete(PackageInstance pkg) {
        s_cat.debug("onDelete");
    }
}
