/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.DataCollection;

/**
 * Represents a collection of parties.
 *
 * @author Oumi Mehrotra 
 * @version 1.0
 **/
public class ExampleMessageCollection extends ACSObjectCollection {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/ExampleMessageCollection.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see com.arsdigita.domain.ACSObjectCollection#ACSObjectCollection(DataCollection)
     **/
    public ExampleMessageCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns the URI for this Message.
     *
     * @return the URI for this Message.
     **/
    public String getSubject() {
        return (String) m_dataCollection.get("subject");
    }

    /**
     * Returns the URI for this Message.
     *
     * @return the URI for this Message.
     **/
    public String getBody() {
        return (String) m_dataCollection.get("message");
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as a <code>Message</code>.
     *
     * @return a <code>Message</code> for the current position in the
     * collection.
     *
     * @see ACSObjectCollection#getDomainObject()
     * @see Message
     * @see com.arsdigita.domain.DomainObject
     **/
    public ExampleMessage getMessage() {
        return (ExampleMessage) getDomainObject();
    }

}
