/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.arsdigita.xml.Document;

import com.arsdigita.util.*;

import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Option;

import org.apache.oro.text.perl.Perl5Util;

// logging
import org.apache.log4j.Logger;


/**
 * When testing persistent Bebop components, we use this XML helper class
 * to determine if two components generate identical XML.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/XMLComparator.java#11 $
 *
 */
public class XMLComparator {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/XMLComparator.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static Logger s_log =
        Logger.getLogger(XMLComparator.class.getName());

    private static String generateXML(Component component) {

        Document document;

        Page page;
        PageState pageState;

        try {

            page = new Page("Test Page");

            Class widgetClass = Class.forName("com.arsdigita.bebop.form.Widget");

            // Widgets are a special case - they need to be added to a form
            // We also add Options and FormSections to Forms
            if (widgetClass.isAssignableFrom(component.getClass()) ||
                component instanceof com.arsdigita.bebop.form.Option ||
                (component instanceof com.arsdigita.bebop.FormSection &&
                 !(component instanceof com.arsdigita.bebop.Form))) {

                Form form = new Form("no_name");

                // Options need to be added to an option group
                if (component instanceof com.arsdigita.bebop.form.Option) {
                    SingleSelect select = new SingleSelect("test select");
                    select.addOption((Option)component);
                    form.add(select);

                } else {
                    form.add(component);
                }

                page.add(form);

            } else {

                page.add(component);
            }

            page.lock();

            HttpServletRequest request = new HttpServletDummyRequest();
            HttpServletResponse response = new HttpServletDummyResponse();

            pageState = new PageState(page, request, response);

            document = new Document();

        } catch (Exception e) {

            s_log.debug(e);

            throw new UncheckedWrapperException(e);
        }

        page.generateXML(pageState, document);

        return stripOffDebugInfo(document.toString());
    }

    /**
     * Have to strip it off since it contains the class name
     * and therefore we would never get equality
     */
    private static String stripOffDebugInfo(String xml) {
        Perl5Util perl = new Perl5Util();

        return perl.substitute("s/<bebop:structure[^>]*>[^<>]*<\\/bebop:structure>//", xml);
    }

    public static boolean haveEqualXML(Component component1, Component component2) {

        String xml1 = generateXML(component1);
        String xml2 = generateXML(component2);

        boolean xmlIsEqual = xml1.equals(xml2);

        if (!xmlIsEqual) {

            s_log.debug("component1 xml: " + xml1);
            s_log.debug("component2 xml: " + xml2);
        }

        return xmlIsEqual;
    }
}
