/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// The class we are testing here
import com.arsdigita.formbuilder.PersistentForm;

// Interfaces used by the component base test case
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.bebop.Component;

// Reference
import com.arsdigita.bebop.Form;

// logging
import org.apache.log4j.Logger;


/**
 * Test the PersistentForm class with the test pattern defined in
 * the PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentFormTest.java#11 $
 *
 */
public class PersistentFormTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentFormTest.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(PersistentFormTest.class.getName());

    // Common attributes of the forms
    protected String m_htmlName = "test_form";
    protected String m_action = "test_action_url";

    // We reuse the test logic in the form section test through composition
    // and delegation
    private PersistentFormSectionTest m_formSectionTest =
        new PersistentFormSectionTest("Form Section Test");

    /**
     * JUnit needs this constructor
     */
    public PersistentFormTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentForm persistentForm = PersistentForm.create(m_htmlName);

        // Add all components that we add to the form section
        m_formSectionTest.setFormSectionData(persistentForm);

        // Add the form section
        persistentForm.addComponent
            (m_formSectionTest.createPrimaryPersistentFactory());

        // Set the action attribute
        persistentForm.setAction(m_action);

        return persistentForm;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {

        Form form = new Form(m_htmlName);

        m_formSectionTest.addComponentsToReference(form);

        // Add the form section
        form.add(m_formSectionTest.createPrimaryReferenceComponent());

        form.setAction(m_action);

        return form;
    }

    /**
     * Some components have attributes that the corresponding Bebop component
     * does not have. Those should be checked (after the component has been
     * retrieved from the database) in this method.
     */
    protected void checkPersistenceAttributes(PersistentComponentFactory factory) {

        m_formSectionTest.checkPersistenceAttributes(factory);
    }
}
