/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;

import org.apache.log4j.Logger;

/**
 * Represents a Java Class and its dependency relationships.
 * @see http://www.clarkware.com/software/JDepend.html
 *
 * @author Jon Orris
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */
public class JavaClass extends DomainObject  {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/domain/JavaClass.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger log =
        Logger.getLogger(JavaClass.class.getName());

    /**
     * BASE_DATA_OBJECT_TYPE represents the full objectType name for the
     * class
     **/
    private static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.domain.Class";


    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }


    public JavaClass(DataObject object) {
        super(object);
    }


    /**
     * Constructor. The contained DataObject is
     * initialized with a new DataObject with an
     * ObjectType specified by the string
     * typeName.
     *
     * @param typeName The name of the ObjectType of the
     * contained DataObject.
     *
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.metadata.ObjectType
     **/
    public JavaClass(String typeName) {
        super(typeName);
    }

    /**
     * Constructor. The contained DataObject is
     * initialized with a new DataObject with an
     * ObjectType specified by type.
     *
     * @param type The ObjectType of the contained
     * DataObject.
     *
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.metadata.ObjectType
     **/
    public JavaClass(ObjectType type) {
        super(type);
    }


    /**
     * Constructor. Retrieves a JavaClass instance, retrieving an existing
     * note from the database with OID oid. Throws an exception if an
     * object with OID oid does not exist or the object is not of type JavaClass
     *
     * @param oid The OID for the retrieved
     * DataObject.
     *
     * @see com.arsdigita.persistence.DataObject
     * @see com.arsdigita.persistence.OID
     *
     * @exception DataObjectNotFoundException Thrown if we cannot
     * retrieve a data object for the specified OID
     *
     **/
    public JavaClass(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getName() {
        return (String) get("name");

    }

    public void setName(String name) {
        set("name", name);
    }

    public boolean isAbstract() {
        return ((Boolean) get("isAbstract")).booleanValue();
    }

    public JavaPackage getPackage() {
        return (JavaPackage) DomainObjectFactory.newInstance((DataObject) get("package"));
    }



}
